export interface Args {
  curPage: number;
  perPage: 20 | 50 | 100;
  filters: {
    numref: string;
    title: string;
    department: string;
    brand: string;
    season: string;
    product_id: "existing" | "missing" | "";
  };
  sorting: {
    orderby: "numref" | "title" | "brand" | "department" | "season" | "exists";
    order: "ASC" | "DESC";
  };
}

export interface FilterOptions {
  departments: string[];
  brands: string[];
  seasons: string[];
}

export interface ProductData {
  numref: string;
  title: string;
  product_id: number;
  skus: {
    numref: string;
    sku: string;
    product_id: number | null;
    title: string;
    brand: string;
    department: string;
    season: string;
    attributes: {
      couleur?: string;
      grandeur?: string;
      largeur?: string;
    };
    stock: number;
    regular_price: string;
    sale_price: string;
    suggested_price: string;
  };
}

declare global {
  const rpsyncOptions: {
    ajaxUrl: string;
    filterOptions: FilterOptions;
  };
}

export {};
