<?php

class RPSync_Dashboard {

	public function __construct() {
		// Register script / style
		rpsync_register_script( 'rpsync-vendor', 'assets/js/vendor.js' );
		rpsync_register_script( 'rpsync', 'assets/js/main.js', array( 'rpsync-vendor' ) );
		rpsync_register_style( 'rpsync-vendor', 'assets/css/vendor.css' );
		rpsync_register_style( 'rpsync', 'assets/css/main.css', array( 'rpsync-vendor' ) );

		add_action( 'admin_menu', array( $this, 'admin_menu' ) );
		add_action( 'wp_ajax_rpsync_dashboard', array( $this, 'ajax_rpsync_dashboard' ) );
	}

	/**
	 * Add RPSync dashboard admin menu item
	 * @return void
	 */
	public function admin_menu() {
		add_submenu_page(
			'tools.php',
			"RPSync dashboard",
			"RPSync dashboard",
			'manage_options',
			'rpsync-dashboard',
			array( $this, 'page_callback' ),
		);
	}

	/**
	 * Page callback for RPSync dashboard
	 * @return void
	 */
	public function page_callback() {
		wp_enqueue_script( 'rpsync' );
		wp_enqueue_style( 'rpsync' );
		wp_localize_script( 'rpsync', 'rpsyncOptions', array(
			'ajaxUrl'       => add_query_arg( array(
				'action'   => 'rpsync_dashboard',
				'security' => wp_create_nonce( 'rpsync_dashboard' ),
			), admin_url( 'admin-ajax.php' ) ),
			'filterOptions' => $this->get_filter_options(),
		) );
		?>
		<div class="wrap">
			<h1>RPSync dashboard</h1>
			<div id="rpsync-app">
				<rpsync-dashboard>Initializing RPSync dashboard...</rpsync-dashboard>
			</div>
		</div>
		<?php
	}

	/**
	 * Get available filter options
	 * @return string[][]
	 */
	public function get_filter_options() {
		// TODO: Cache filter options in transient
		function get_distinct_values( $column ) {
			global $wpdb;
			$products_table = RPSync::get_instance()->database->products_table;
			return array_values( array_column( $wpdb->get_results( "SELECT DISTINCT $column FROM $products_table ORDER BY $column ASC", ARRAY_A ), $column ) );
		}

		$filter_options = array(
			'departments' => get_distinct_values( 'department' ),
			'brands'      => get_distinct_values( 'brand' ),
			'seasons'     => get_distinct_values( 'season' ),
		);


		return $filter_options;
	}

	/**
	 * AJAX action for RPSync dashboard
	 *
	 * @return void
	 */
	public function ajax_rpsync_dashboard() {
		check_ajax_referer( 'rpsync_dashboard', 'security' );
		$result = array();
		switch ( $operation = $_POST['operation'] ?? 'undefined' ) {
			case 'fetch':
				$result = RPSync::get_instance()->database->fetch_products( array(
					'offset'  => ( $_POST['args']['curPage'] - 1 ) * $_POST['args']['perPage'],
					'limit'   => $_POST['args']['perPage'],
					'filters' => array_filter( $_POST['args']['filters'] ),
					'sorting' => array_filter( $_POST['args']['sorting'] ),
				) );
				break;

			case 'create':
				try {
					if ( ! RPSync::get_instance()->woocommerce->create_product( $_POST['numref'] ) ) {
						$result = array( 'error' => "Impossible de créer le produit." );
					}
				} catch ( Exception $error ) {
					$result = array( 'error' => $error->getMessage() );
				}
				break;

			case 'update':
				if ( ! empty( $_POST['numref'] ) ) {
					do_action( 'rpsync_process_product_data', $_POST['numref'] );
				} else {
					$result = array( 'error' => "Impossible de mettre à jour le produit." );
				}
				break;

			case 'destroy':
				if ( ! RPSync::get_instance()->woocommerce->destroy_product( $_POST['numref'] ) ) {
					$result = array( 'error' => "Impossible de supprimer le produit." );
				}
				break;

			default:
				$result = array( 'error' => "Opération invalide ($operation)" );
		}

		wp_die( json_encode( $result ) );
	}
}
