/* eslint-disable @typescript-eslint/no-var-requires */
const { resolve } = require("path");
const defaultConfig = require("@lewebsimple/webpack5-config");
const { DefinePlugin, ProvidePlugin } = require("webpack");
const { merge } = require("webpack-merge");
const pkg = require("./package.json");
const mode = process.argv.includes("production") ? "production" : "development";

const projectConfig = {
  entry: "./src/main.ts",

  output: {
    filename: "js/[name].js",
    path: resolve(__dirname, "assets"),
    publicPath: "/wp-content/plugins/rpsync/assets/",
  },

  externals: { jquery: "jQuery" },

  plugins: [
    // Define useful constants
    new DefinePlugin({
      MODE: JSON.stringify(mode),
      DESCRIPTION: JSON.stringify(pkg.description),
      VERSION: JSON.stringify(pkg.version),
    }),

    // Provide jQuery globally
    new ProvidePlugin({
      $: "jquery",
      "global.$": "jquery",
      "window.$": "jquery",
    }),
  ],

  devtool: mode === "development" ? "source-map" : false,
};

module.exports = merge(defaultConfig, projectConfig);
