<?php

namespace Vibe\Split_Orders\Addons;

use Vibe\Split_Orders\Split_Orders;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

/**
 * Provides support for Subscriptions plugin
 *
 * @since 1.4
 */
class Subscriptions {

	/**
	 * Creates an instance and sets up hooks to integrate with the rest of the extension, only if Subscriptions is
	 * installed
	 */
	public function __construct() {
		add_action( Split_Orders::hook_prefix( 'can_split' ), array( __CLASS__, 'can_split' ), 10, 2 );
	}

	/**
	 * Filters the support of splitting for subscription orders
	 *
	 * @param bool $can_split If the order is able to be split by the current user or not
	 * @param \WC_Order $order The order to allow to be split or not
	 * @return bool False if the order is for a subscription renewal, resubscribe or switch, otherwise the core logic is
	 *              used to determine if the order should be split.
	 */
	public static function can_split( $can_split, $order ) {
		if ( $can_split && function_exists( 'wcs_order_contains_subscription' ) ) {

			if ( ! $order || $order->get_type() == 'shop_subscription' || wcs_order_contains_subscription( $order, array( 'switch', 'resubscribe' ) ) ) {
				$can_split = false;
			}
		}

		return $can_split;
	}
}
