let vibe_split_orders = (function( $ ) {

	/**
	 * The line items div
	 */
	let $postbox;

	let _init = function() {
		$postbox = $( '#woocommerce-order-items' );

		if ( $postbox.length > 0 ) {
			$postbox.on( 'click', 'button.split-order', _begin_split_order );
		}

		$( document.body ).on( 'wc_backbone_modal_response', _popup_confirmed );
	};

	let _begin_split_order = function( e ) {
		e.preventDefault();

		_show_popup();
	};

	let _block_el = function( $el ) {
		$el.block( {
			message: null, overlayCSS: {
				background: '#fff', opacity: 0.6
			}
		} );
	};

	let _unblock_el = function( $el ) {
		$el.unblock();
	};

	let _show_popup = function() {
		$( this ).WCBackboneModal( {
			template: 'wc-modal-split-order'
		} );

		_refresh_popup();
	};

	let _popup_confirmed = function( event, target ) {
		if ( 'wc-modal-split-order' === target ) {
			_split_order();
		}
	};

	let _refresh_popup = function() {
		_block_el( $( '#modal-split-order-line-items' ) );

		let data = {
			action:   'vibe_split_orders_popup_line_items',
			nonce:    vibe_split_orders_data.popup_nonce,
			order_id: $( 'button.split-order' ).data('id')
		};

		$.get( vibe_split_orders_data.ajaxurl, data, _show_popup_response )
	};

	let _show_popup_response = function( response ) {
		let $modal_container = $( '#modal-split-order-line-items' );
		_unblock_el( $modal_container );

		if ( response.success ) {
			$modal_container.html( response.html );

			_setup_popup_handlers();
		}
	};

	let _setup_popup_handlers = function() {
		$( '#split-orders-popup .all-qty-link' ).on( 'click', function( e ) {
			e.preventDefault();

			let $product = $(this).closest( '.item.product' );
			$product.find( '.qty-split' ).focus().val( $product.data( 'qty' ) );
		} );

		$( '#split-orders-popup .all-total-link' ).on( 'click', function( e ) {
			e.preventDefault();

			let $product = $(this).closest( '.item.shipping' );
			$product.find( '.total-split' ).focus().val( $product.data( 'total' ) );
		} );
	};

	let _split_order = function() {
		_block_el( $postbox );

		let $popup = $( '#split-orders-popup' );
		let items = {};
		let shipping = {};

		$popup.find( '.item.product' ).each( function() {
			let $item = $( this );

			let qty = parseFloat( $item.find( '.qty-split' ).val() );

			if ( qty ) {
				items[ $item.data( 'item-id' ) ] = qty;
			}
		} );

		$popup.find( '.item.shipping' ).each( function() {
			let $item = $( this );

			let total = parseFloat( $item.find( '.total-split' ).val() );

			// Proceed if the total is any valid number (including 0)
			if ( isFinite( total ) ) {
				shipping[ $item.data( 'item-id' ) ] = total;
			}
		} );

		let data = {
			action:   'vibe_split_orders_split_order',
			nonce:    vibe_split_orders_data.splitting_nonce,
			items:    items,
			shipping: shipping,
			order_id: $popup.data( 'order-id' )
		};

		$.post( vibe_split_orders_data.ajaxurl, data, _split_order_response );
	};

	let _split_order_response = function( response ) {
		_unblock_el( $postbox );

		if ( response.success ) {
			window.location.reload();
		} else {
			_show_alert( response );
		}
	};

	let _show_alert = function( response ) {
		$( this ).WCBackboneModal( {
			template: 'wc-modal-split-order-alert',
			variable: response
		} );

		// Set up the copy to clipboard functionality
		$('#split-order-alert-copy-to-clipboard').on('click', () => {
			let $log = $('#split-order-alert-log').select();

			navigator.clipboard.writeText($log.text());
		});
	};

	$( _init );

	return {};

})( jQuery );