<?php

namespace Vibe\Split_Orders;

use WC_Settings_Page;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

/**
 * Creates the Orders settings tab if it does not exist
 *
 * @since 1.8.0
 */
class Settings_Tab_Orders extends WC_Settings_Page {

	/**
	 * Creates an instance and sets up the hooks to integrate with the admin
	 */
	public function __construct() {
		$this->id    = 'vibe-orders';
		$this->label = __( 'Orders', 'split-orders' );

		parent::__construct();
	}

	/**
	 * Get own sections.
	 *
	 * @return array
	 */
	protected function get_own_sections() {
		return array();
	}

	/**
	 * Add this page to settings.
	 *
	 * @param array $pages The settings array where we'll add ourselves.
	 *
	 * @return mixed
	 */
	public function add_settings_page( $pages ) {
		$new_pages = array();
		$added = false;

		// Keep all existing settings pages, but add ours after Email
		foreach ( $pages as $page_id => $page_label ) {
			$new_pages[ $page_id ] = $page_label;

			if ( 'email' === $page_id ) {
				$added = true;
				$new_pages[ $this->id ] = $this->label;
			}
		}

		// If the email tab doesn't exist, add our tab at the end
		if ( ! $added ) {
			$new_pages[ $this->id ] = $this->label;
		}

		return $new_pages;
	}
}
