<?php

namespace Vibe\Split_Orders;

use Vibe\Split_Orders\Upgrades\Upgrades;

/**
 * Sets up system status report modifications
 *
 * @since 1.0.0
 */
class System_Status {

	/**
	 * Creates an instance and sets up the hooks to integrate with the system status report
	 */
	public function __construct() {
		add_filter( 'woocommerce_system_status_report', array( __CLASS__, 'render_system_status_items' ) );
	}

	public static function render_system_status_items() {
		$section_title = _x( 'Split Orders', 'status report section title', 'split-orders' );
		$section_tooltip = __( 'This section shows information about the Split Orders extension', 'split-orders' );
		$debug_data['db_version'] = array(
			'name'      => _x( 'Database version', 'system status item', 'split-orders' ),
			'label'     => 'Database version',
			'data'      => array( Upgrades::db_version() )
		);
		$debug_data['order_status'] = array(
			'name'      => _x( 'Order status', 'system status item', 'split-orders' ),
			'label'     => 'Order status',
			'data'      => array( Settings::split_order_status() )
		);
		$debug_data['meta_fields'] = array(
			'name'      => _x( 'Meta fields', 'system status item', 'split-orders' ),
			'label'     => 'Meta fields',
			'data'      => Settings::meta_fields()
		);

		$debug_data = apply_filters( Split_Orders::hook_prefix( 'system_status_items' ), $debug_data );
		?>

		<table class="wc_status_table widefat" cellspacing="0">
			<thead>
			<tr>
				<th colspan="3" data-export-label="<?php echo esc_attr( $section_title ); ?>">
					<h2><?php echo esc_html( $section_title ); ?>
						<?php echo wc_help_tip( $section_tooltip ); ?>
					</h2></th>
			</tr>
			</thead>
			<tbody>
			<?php foreach ( $debug_data as $section => $data ) : ?>
				<?php
				// Use mark key if available, otherwise default back to the success key.
				if ( isset( $data['mark'] ) ) {
					$mark = $data['mark'];
				} elseif ( isset( $data['success'] ) && $data['success'] ) {
					$mark = 'yes';
				} else {
					$mark = 'error';
				}

				// Use mark_icon key if available, otherwise set based on $mark
				if ( isset( $data['mark_icon'] ) ) {
					$mark_icon = $data['mark_icon'];
				} elseif ( 'yes' === $mark ) {
					$mark_icon = 'yes';
				} else {
					$mark_icon = 'no-alt';
				}
				?>
				<tr class="<?php echo sanitize_html_class( $section ); ?>">
					<td data-export-label="<?php echo esc_attr( $data['label'] ); ?>"><?php echo esc_html( $data['name'] ); ?>:</td>
					<td class="help">&nbsp;</td>
					<td>
						<?php
						if ( isset( $data['data'] ) ) {

							if ( empty( $data['data'] ) ) {
								echo '&ndash;';
								continue;
							}

							$row_number = count( $data['data'] );

							foreach ( $data['data'] as $row ) {
								echo wp_kses_post( $row );

								if ( 1 != $row_number ) {
									echo ', ';
								}
								echo '<br />';
								$row_number--;
							}
						}
						if ( isset( $data['note'] ) ) {
							if ( empty( $mark ) ) {
								echo wp_kses_post( $data['note'] );
							} else {
								echo '<mark class="<?php echo esc_html( $mark ) ?>">';
								if ( $mark_icon ) {
									echo '<span class="dashicons dashicons-' . esc_attr( $mark_icon ) . '"></span> ';
								}
								echo wp_kses_post( $data['note'] );
								echo '</mark>';
							}
						}
						?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>

		<?php
	}
}
