<?php

namespace Vibe\Split_Orders\Addons;

use Vibe\Split_Orders\Order_Numbers;
use Vibe\Split_Orders\Settings;
use Vibe\Split_Orders\Split_Orders;
use WC_Order;

defined( 'ABSPATH' ) || exit; // Exit if accessed directly

/**
 * Provides support for Editable Order Numbers plugin
 *
 * @since 1.7
 */
class Editable_Order_Numbers {

	/**
	 * Creates an instance and sets up hooks to integrate with the rest of the extension, only if Sequential Order
	 * Numbers Pro plugin is installed
	 */
	public function __construct() {
		add_filter( Split_Orders::hook_prefix( 'order_number_settings_active' ), '__return_true' );
		add_action( Split_Orders::hook_prefix( 'orders_updated' ), array( __CLASS__, 'orders_updated' ), 10, 2 );
	}

	/**
	 * Assigns a sequential order number to newly created orders in a split
	 *
	 * @param WC_Order $new_order The newly created order
	 */
	public static function orders_updated( WC_Order $new_order, WC_Order $source_order ) {
		if ( ! class_exists( 'Vibe\Edit_Order_Numbers\Edit_Order_Numbers' ) ) {
			return;
		}

		if ( Settings::order_number_suffix_enabled() ) {
			$order_number = Order_Numbers::generate( $new_order, $source_order );

			\Vibe\Edit_Order_Numbers\Order_Numbers::update_order_number( $new_order, $order_number );
		}
	}
}
