<?php

namespace Vibe\Split_Orders;

/**
 * Utility functions for general use
 *
 * @since 1.7.0
 */
class Utilities {

	/**
	 * Attempts to identify which plugin a file belongs to, based on its location in the directory structure.
	 *
	 * @param string $file The path to a plugin file
	 *
	 * @return array|null An array representing the plugin the file belongs to, or null if no plugin could be identified
	 */
	public static function identify_plugin( $file ) {
		$installed_plugins = get_plugins();

		// Remove WooCommerce and self to avoid confusing message
		unset( $installed_plugins['woocommerce/woocommerce.php'] );
		unset( $installed_plugins['split-orders/split-orders.php'] );

		// Strip off the plugin directory path
		$plugin_basename = plugin_basename( $file );

		$plugin = null;

		// Check if the file is itself in the list of plugins.
		if ( array_key_exists( $plugin_basename, $installed_plugins ) ) {
			$plugin = $installed_plugins[ $file ];
		} else {
			// Extract the directory so we can look for a plugin using the same directory
			$plugin_dir = current( explode( DIRECTORY_SEPARATOR, $plugin_basename ) );

			foreach ( $installed_plugins as $installed_plugin_file => $installed_plugin ) {
				$installed_plugin_dir = current( explode( DIRECTORY_SEPARATOR, $installed_plugin_file ) );

				if ($installed_plugin_dir == $plugin_dir) {
					$plugin = $installed_plugin;
					break;
				}
			}
		}

		return $plugin;
	}

	/**
	 * Returns a price string formatted according to the current decimal formatting settings
	 *
	 * @param float $price A price decimal, defaulting to zero
	 * @return string A string to represent a zero price
	 */
	public static function format_price_decimal( $price = 0 ) {
		$price = floatval( $price );

		$separator = wc_get_price_decimal_separator();
		$decimals = wc_get_price_decimals();

		return number_format( $price, $decimals, $separator );
	}
}
