let vibe_split_orders_settings = (function( $ ) {

	let $custom_meta_fields;

	let _init = function() {
		$custom_meta_fields = $( '#vibe_split_orders_meta_fields' );

		if ( $custom_meta_fields.length > 0 ) {
			_render_suggested_meta();
		}

		$( document.body ).on( 'click', '#vibe_suggested_meta a', _meta_clicked );
	};

	let _append_meta_field = function( new_field ) {
		let metafields = $custom_meta_fields.val();

		// Try to preserve the same separator for the user
		let uses_commas = metafields.includes( ',' );
		let uses_newlines = metafields.trim().includes( '\n' );
		let separator = ',\n';

		if (uses_newlines && !uses_commas) {
			separator = '\n';
		} else if (uses_commas && !uses_newlines) {
			separator = ', ';
		}

		// Clean up list of meta fields into an array and remove whitespace and blanks
		metafields = metafields.split( /[\n,]/ ).map( e => e.trim() ).filter( e => (e !== '') );

		// Add the new item if it doesn't already exist
		if ( ! metafields.includes( new_field ) ) {
			metafields.push( new_field );

			$custom_meta_fields.val( metafields.join( separator ) );
		}
	};

	let _meta_clicked = function( e ) {
		e.preventDefault();

		_append_meta_field( e.target.text );
	};

	let _render_suggested_meta = function() {
		let fields = vibe_split_orders_data.suggested_meta_fields;
		fields = fields.map(e => '<a href="#">' + e + '</a>').join(', ');

		if ( fields ) {
			$custom_meta_fields.parent().append( '<div id="vibe_suggested_meta"><p>' + vibe_split_orders_data.recent_fields_label + ' </p>' + fields + '</div>' );
		}
	};

	$( _init );

	return {};

})( jQuery );