/*
 * Copyright 2012-2021, Theia Smart Thumbnails, WeCodePixels, https://wecodepixels.com
 */
var tst = tst || {};

jQuery(function ($) {
    tst.adjustBackgroundImages = function (tstLoadedImages) {
        // Browse through all image IDs.
        for (var id in tstLoadedImages) {
            var image = tstLoadedImages[id];

            // Browse through all URLs.
            for (var i = 0; i < image.urls.length; i++) {
                var url = image.urls[i];

                // Find elements using this URL.
                var elements = $('*').filter(function () {
                    var $this = $(this);
                    var backgroundImage = $this.css('backgroundImage');

                    // Fix for avia-slideshow.
                    if (!backgroundImage || backgroundImage === 'none') {
                        backgroundImage = $this.attr('data-img-url');
                    }

                    // Only applies to cover images.
                    if (!backgroundImage || $(this).css('backgroundSize') !== 'cover') {
                        return false;
                    }

                    // Search for URL directly.
                    var found = backgroundImage.indexOf(url) !== -1;

                    // Try to decode URL.
                    if (!found) {
                        try {
                            if (decodeURIComponent(backgroundImage).indexOf(url) !== -1) {
                                found = true;
                            }
                        } catch (e) {
                        }
                    }

                    return found;
                });

                elements.each(function () {
                    var $this = $(this);

                    $this.css('background-position-x', image.focusPointX * 100 + '%');
                    $this.css('background-position-y', image.focusPointY * 100 + '%');
                });
            }
        }
    };
});

jQuery(document).on('ready', function () {
    if (typeof tstLoadedImages !== 'undefined') {
        tst.adjustBackgroundImages(tstLoadedImages);
    }
});
