<?php
/*
Plugin Name: VC File Picker
Description: File picker field type for WPBakery Page Builder.
Version:     1.0.0
Author:      Le Web simple <pascal@lewebsimple.ca>
Author URI:  https://lewebsimple.ca
Text Domain: vc-file-picker
Domain Path: /languages
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'VC_File_Picker' ) ) :

	class VC_File_Picker {
		/** @var string The plugin version number. */
		var $version = '1.0.0';

		/**
		 * VC_File_Picker constructor.
		 */
		function __construct() {
			// Do nothing.
		}

		/**
		 * Initialize ACF Polylang
		 */
		function initialize() {
			// Bail early if already initialized
			if ( defined( 'VC_FILE_PICKER_VERSION' ) ) {
				return;
			}

			// Check for WPBakery Visual Composer
			if ( ! function_exists( 'vc_add_shortcode_param' ) ) {
				return;
			}

			// Define constants
			$this->define( 'VC_FILE_PICKER_VERSION', $this->version );

			vc_add_shortcode_param( 'file_picker', 'vc_file_picker_settings_field', plugin_dir_url( __FILE__ ) . 'js/file-picker.js' );
		}

		/**
		 * Defines a constant if doesnt already exist.
		 *
		 * @param $name
		 * @param bool $value
		 */
		function define( $name, $value = true ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}
	}

	/**
	 * Add file picker shartcode param
	 *
	 * @param $settings
	 * @param $value
	 *
	 * @return string
	 */
	function vc_file_picker_settings_field( $settings, $value ) {
		$select_file_class = '';
		$remove_file_class = ' hidden';
		$attachment_url    = wp_get_attachment_url( $value );
		if ( $attachment_url ) {
			$select_file_class = ' hidden';
			$remove_file_class = '';
		}
		ob_start();
		?>
		<div class="file_picker_block">
			<div class="<?= esc_attr( $settings['type'] ) ?>_display">
				<?= $attachment_url ?>
			</div>
			<input type="hidden" name="<?= esc_attr( $settings['param_name'] ) ?>"
			       class="wpb_vc_param_value wpb-textinput <?= esc_attr( $settings['param_name'] ) ?> <?= esc_attr( $settings['type'] ) ?>_field"
			       value="<?= esc_attr( $value ) ?>"/>
			<button class="button file-picker-button <?= $select_file_class ?>">
				<?= __( "Select file", 'vc-file-picker' ) ?>
			</button>
			<button class="button file-remover-button <?= $remove_file_class ?>">
				<?= __( "Remove file", 'vc-file-picker' ) ?>
			</button>
		</div>
		<?php

		return ob_get_clean();
	}

	/**
	 * The main function responsible for returning the one true VC_File_Picker Instance to functions everywhere.
	 * Use this function like you would a global variable, except without needing to declare the global.
	 *
	 * @return    VC_File_Picker
	 */
	function vc_file_picker() {
		global $vc_file_picker;

		// Instantiate only once.
		if ( ! isset( $vc_file_picker ) ) {
			$vc_file_picker = new VC_File_Picker();
			$vc_file_picker->initialize();
		}

		return $vc_file_picker;
	}

	// Instantiate.
	vc_file_picker();

endif;
