<?php
/**
 * Pick List
 *
 * @package picklist/includes
 */

defined( 'ABSPATH' ) || exit;


/**
 * Class for same customer orders
 */
class Cas_Pick_Customers {

	/**
	 * List customers orders
	 *
	 * @since 2.5.10
	 */
	public static function cas_tab_customers_orders() {
		?>
		<div class="wrap">
			<?php
				self::cas_create_customer_table();
			?>
		</div>
		<?php
	}

	public static function cas_create_customer_table() {

		$status_filter   = ( ! empty( filter_input( 1, 'status', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? explode( ',', filter_input( 1, 'status', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) : array();
		$customer        = ( ! empty( filter_input( 1, 'customer', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? filter_input( 1, 'customer', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) : 0;
		$page_num        = ( ! empty( filter_input( 1, 'paged', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? filter_input( 1, 'paged', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) : 1;
		$orders          = Cas_Pick_Functions::cas_get_customer_orders( $customer, $status_filter );
		$date_format     = get_option( 'date_format' );
		$time_format     = get_option( 'time_format' );
		$currency_pos    = get_option( 'woocommerce_currency_pos' );
		$url             = admin_url( 'admin.php?page=picklist' );
		$url_order       = admin_url( 'post.php?post=' );
		$url_c_orders    = admin_url( 'admin.php?page=picklist&tab=customers&customer=' );
		$search_str      = ( ! empty( filter_input( 1, 's', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? filter_input( 1, 's', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) : '';
		$options         = get_option( 'picklist_options' );
		
		
		/**
		 * Filter whether to hide prices for the current user.
		 *
		 * This filter checks if the current user should have prices hidden
		 * based on the 'picklist_options' settings in the database.
		 * 
		 * @since vs 2.4.25
		 *
		 * @param bool $hide Whether to hide prices for the user (default: false).
		 * @return bool
		 */		
		$hide_prices = apply_filters( 'cas_pick_hide_prices_for_user', false );

	   
		// Search message.
		// translators: 1: number of results, 2: search string.
		$search_message = sprintf(
			/* translators: 1: number of results, 2: search string. */
			esc_html__( 'Showing %1$s most relevant results for "%2$s" – refine your search for more accurate matches.', 'woo-picklist' ),
			esc_html( count( $orders['orders'] ) ),
			esc_html( $search_str )
		);

		?>
		<div class="woo-picklist-container">
		
		<?php Cas_Pick_Unpicked::cas_get_status_dialog(); ?>

		<div class="cas-head-timer-search">
			<div style="flex-grow:3;padding-top:4px;">
				<?php if ( ! empty( $search_str ) ) : ?>
					<span class="notice notice-info" style="padding:7px;"><i class="fa-solid fa-circle-info"></i> <?php echo esc_attr( $search_message ); ?></span>
				<?php endif; ?>
			</div>
			<div class="cas-search-form">
				<span>
					<form method="get" autocomplete="off" action="<?php echo esc_attr( $url ); ?>"> 
						<input type="hidden" name="page" value="picklist">
						<input type="hidden" name="tab" value="customers">
						<input type="search" name="s" placeholder="<?php echo esc_attr__( 'Search Customer', 'woo-picklist' ); ?>" value="<?php echo esc_attr( $search_str ); ?>">
						<button type="submit" class="button" title="<?php echo esc_attr__( 'Search', 'woo-picklist' ); ?>"> <i class="fa-solid fa-magnifying-glass"></i> </button>
					</form>
				</span>
			</div>
		</div>
		
		<div class="cas-pick-order-filters" style="padding-bottom:10px;">
			<div>
				<form method="get" autocomplete="off" action="<?php echo esc_attr( $url ); ?>" onchange="this.submit();">
					<input type="hidden" name="page" value="picklist">
					<input type="hidden" name="tab" value="customers">
					<?php Cas_Pick_Functions::cas_get_unique_customers_dropdown(); ?>
				</form> 
			</div>
			<div style="padding-bottom: 5px;text-align:right;flex-grow:4;">
				<?php if ( count( $orders['orders'] ) > 0 ) : ?>
					<?php Cas_Pick_Functions::cas_get_paging( $page_num, $orders['total_pages'] ); ?>
				<?php endif; ?>
			</div>
		</div>
		
		<?php $col_count = 3; ?>
		<?php wp_nonce_field( 'cas_pick_id' ); ?>
		<div class="cas-div-table-container">
		<table id="cas-pick-customer-table" class="widefat striped posts cas-pick-table cas-orders-list" style="width:100%;">
			<thead>
				<tr>
				<th><a href="#" onclick="casSortCol(0,'number','s','cas-pick-customer-table');"><i id="s0" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Order ID', 'woo-picklist' ); ?></a></th>
				<th><a href="#" onclick="casSortCol(1,'date','s','cas-pick-customer-table');"><i id="s1" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Date', 'woo-picklist' ); ?></a></th>
				<th><a href="#" onclick="casSortCol(2,'text','s','cas-pick-customer-table');"><i id="s2" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Customer', 'woo-picklist' ); ?></a></th>
				<th><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Ship To', 'woo-picklist' ); ?></a></th>
				
				<?php 
				if ( 'yes' === $options['cas_pick_show_role'] ) : 
					?>
					<?php $col_count++; ?>
					<th><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Role', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<th><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Status', 'woo-picklist' ); ?></a></th>
				<th id="cas-th-items" class="cas-tbl-center" style="text-align:center;"><?php $col_count++; ?>
					<a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'number','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Items', 'woo-picklist' ); ?></a>
				</th>
				<?php if ( ! $hide_prices ) : ?>
					<th id="cas-th-total" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'number','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Total', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_show_shipping_information'] ) : ?>
					<?php $col_count++; ?>
					<th id="cas-th-shipping" style="text-align:left;"><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Shipping', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<?php 
				if ( 'yes' === $options['cas_pick_order_custom1_pick'] && strlen( $options['cas_pick_order_custom1'] ) > 0 ) : 
					?>
					<?php $col_count++; ?>
					<th><?php echo esc_attr( $options['cas_pick_order_custom1_lbl'] ); ?></th>
				<?php endif; ?>
				<?php 
				if ( 'yes' === $options['cas_pick_order_custom2_pick'] && strlen( $options['cas_pick_order_custom2'] ) > 0 ) : 
					?>
					<?php $col_count++; ?>
					<th><?php echo esc_attr( $options['cas_pick_order_custom2_lbl'] ); ?></th>
				<?php endif; ?>
				<th class="cas-th-pick"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Priority', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick cas-tbl-center" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'progress','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Progress', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick cas-tbl-center" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-customer-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Assigned to', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick"><?php $col_count++; ?></th>
			</tr>
			</thead>
		<tbody>
		<?php 
		if ( count( $orders['orders'] ) <= 0 ) {
			?>
			<tr>
				<td colspan="20" class="cas-no-data">
					<?php echo esc_attr__( 'No orders found for this customer.', 'woo-picklist' ); ?>
				</td>
			</tr>
			<?php
		} else {
		
			foreach ( $orders['orders'] as $order ) {

				$customer_name  = ( null !== $order->get_billing_first_name() && null !== $order->get_billing_last_name() ) ? $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() : '';
				$progress_value = '0';
				$picked_items   = $order->get_meta( '_cas_pick_order_status_qty', true );
				$pick_percent   = $order->get_meta( '_cas_pick_order_status_percent', true );
				$pick_priority  = $order->get_meta( '_cas_pick_order_priority', true );
				$shipped_count  = ( ! empty( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) && intval( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) > 0 ) ? intval( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) : 0;
				
				if ( ! empty( $pick_percent ) ) {
					$progress_value = intval( $pick_percent );
				} else {
					$pick_percent = 0;
				}

				$priority_color   = Cas_Pick_Functions::cas_get_priority_status_color( $pick_priority );
				$in_pick_progress = false;

				if ( is_array( $picked_items ) ) {
					foreach ( array_values( $picked_items ) as $value ) {
						if ( ! empty( $value ) ) {
							$in_pick_progress = true;
							break;
						}	
					}
				}

				?>
				<tr data-url="<?php echo esc_url( $url . '&tab=single&orderid=' . $order->get_id() . '&tbl=main' ); ?>">
					<td data-label="<?php echo esc_attr__( 'ID:', 'woo-picklist' ); ?>"><a href="<?php echo esc_url( $url_order . $order->get_id() . '&action=edit' ); ?>"><?php echo esc_attr( $order->get_order_number() ); ?></a></td>
					<td data-label="<?php echo esc_attr__( 'Date:', 'woo-picklist' ); ?>">
						<?php echo esc_attr( date_format( new DateTime( $order->get_date_created() ), $date_format ) ); ?><br/>
						<span class="cas-span-smaller"><i class="fa-regular fa-clock"></i> <?php echo esc_attr( date_format( new DateTime( $order->get_date_created() ), $time_format ) ); ?></span>
					</td>
					<td data-label="<?php echo esc_attr__( 'Customer:', 'woo-picklist' ); ?>">
						<a href="<?php echo esc_url( $url_c_orders . ( ( $order->get_customer_id() > 0 ) ? $order->get_customer_id() : $order->get_billing_email() ) ); ?>" title="<?php echo esc_attr__( 'Click to view this customers orders', 'woo-picklist' ); ?>">
							<?php echo esc_attr( $customer_name ); ?><br/>
						</a>
						<small>
							<?php if ( $order->get_billing_email() ) : ?>
								<a href="mailto:<?php echo esc_attr( $order->get_billing_email() ); ?>"><?php echo esc_html( $order->get_billing_email() ); ?></a><br>
							<?php endif; ?>
							<?php if ( $order->get_billing_company() ) : ?>
								<?php echo esc_attr( $order->get_billing_company() ); ?>
							<?php endif; ?>
						</small>
					</td>
					<td data-label="<?php echo esc_attr__( 'Ship To:', 'woo-picklist' ); ?>">
						<?php
							$line1 = $order->get_shipping_address_1();
							$line2 = $order->get_shipping_address_2();
							$city  = $order->get_shipping_city();
							$code  = $order->get_shipping_postcode();
							$state = $order->get_shipping_state();
						?>
						 <small>
							<?php if ( $line1 ) : ?>
								<?php echo esc_html( $line1 ); ?><br>
							<?php endif; ?>

							<?php if ( $line2 ) : ?>
								<?php echo esc_html( $line2 ); ?><br>
							<?php endif; ?>

							<?php if ( $city || $code ) : ?>
								<?php echo esc_html( $code ); ?> <?php echo esc_html( $city ); ?><br>
							<?php endif; ?>

							<?php if ( $state ) : ?>
								<?php echo esc_html( $state ); ?><br>
							<?php endif; ?>
							
							<?php
							$country_code = $order->get_shipping_country();
							if ( ! empty( $country_code ) ) :
								$country_name = WC()->countries->countries[ $country_code ] ?? $country_code;
								?>
								<?php echo esc_html( $country_name ); ?>
							<?php endif; ?>
						</small>
					</td>
					
					<?php if ( 'yes' === $options['cas_pick_show_role'] ) : ?>
						<td data-label="<?php echo esc_attr__( 'Role:', 'woo-picklist' ); ?>"><?php echo esc_attr( $order->get_customer_id() ? Cas_Pick_Functions::cas_get_customer_role( $order->get_customer_id() ) : '' ); ?></td>
					<?php endif; ?>
					<td data-label="<?php echo esc_attr__( 'Status:', 'woo-picklist' ); ?>">
						<i class="fa-solid fa-pen-to-square" onclick="casChangeOrderStatus(this,'<?php echo esc_attr( $order->get_id() ); ?>');" id="cas-change-status-icon" style="color:black;font-size:small;margin-right:2px;" title="<?php echo esc_attr__( 'Change Order Status', 'woo-picklist' ); ?>"></i>
						<span id="cas-current-order-status-<?php echo esc_attr( $order->get_id() ); ?>" class="order-status status-<?php echo esc_attr( $order->get_status() ); ?>"><?php echo esc_attr( wc_get_order_status_name( $order->get_status() ) ); ?></span>
						<?php if ( 'yes' === $order->get_meta( '_cas_pick_order_shipped', true ) ) : ?>
							<i class="fa-solid fa-truck-arrow-right" style="font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Order is shipped', 'woo-picklist' ); ?>"></i>
							<?php if ( ( $shipped_count > 0 && 100.00 !== floatval( $pick_percent ) ) || ( $shipped_count > 1 && 100.00 === floatval( $pick_percent ) ) ) : ?>
								<span class="cas-count-badge-list" title="<?php echo esc_attr__( 'Shipped count', 'woo-picklist' ); ?>"><?php echo esc_attr( $shipped_count ); ?></span>
							<?php endif; ?>
						<?php endif; ?>
						<?php if ( ( 0 !== intval( $progress_value ) && 100 > intval( $progress_value ) ) || ( $in_pick_progress && 100 > intval( $progress_value ) ) ) : ?>
							<i class="fa-solid fa-people-carry-box cas-blink" style="color:darkorange;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Working', 'woo-picklist' ); ?>"></i>
						<?php endif; ?>
						<?php if ( $in_pick_progress && 0 === intval( $progress_value ) ) : ?>
							<i class="fa-solid fa-barcode cas-blink" style="color:black;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Scanning', 'woo-picklist' ); ?>"></i>
						<?php endif; ?>
						<?php if ( 0 === intval( $progress_value ) && strlen( $order->get_meta( '_cas_pick_admin_user', true ) ) > 0 && ! $in_pick_progress ) : ?>
							<i class="fa-solid fa-user-lock" style="color:gray;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'User assigned', 'woo-picklist' ); ?>"></i>
						<?php endif; ?>
					</td>
					<td class="cas-tbl-center" data-label="<?php echo esc_attr__( 'Items:', 'woo-picklist' ); ?>" data-items="items"><?php echo esc_attr( $order->get_item_count() ); ?></td>
					<?php if ( ! $hide_prices ) : ?>
						<td class="cas-tbl-center" data-label="<?php echo esc_attr__( 'Total:', 'woo-picklist' ); ?>" data-total="total"><?php echo wp_kses( wc_price( $order->get_total() ), 'post' ); ?></td>
					<?php endif; ?>
					<?php if ( 'yes' === $options['cas_show_shipping_information'] ) : ?>
						<td data-label="<?php echo esc_attr__( 'Shipping:', 'woo-picklist' ); ?>">
							<span class="cas-span-shipping-method"><?php echo esc_attr( ! empty( $order->get_shipping_method() ) ? $order->get_shipping_method() : '-' ); ?></span>
							<?php if ( ! $hide_prices ) : ?>
								<br/><span class="cas-span-smaller"><?php echo wp_kses( wc_price( $order->get_shipping_total() ), 'post' ); ?></span>
							<?php endif; ?>
						</td>
					<?php endif; ?>
					<?php if ( 'yes' === $options['cas_pick_order_custom1_pick'] && strlen( $options['cas_pick_order_custom1'] ) > 0 ) : ?>
						<td data-label=""><?php echo esc_attr( $order->get_meta( $options['cas_pick_order_custom1'] ) ); ?></td>
					<?php endif; ?>
					<?php if ( 'yes' === $options['cas_pick_order_custom2_pick'] && strlen( $options['cas_pick_order_custom2'] ) > 0 ) : ?>
						<td data-label=""><?php echo esc_attr( $order->get_meta( $options['cas_pick_order_custom2'] ) ); ?></td>
					<?php endif; ?>
					
					<td data-label="<?php echo esc_attr__( 'Priority:', 'woo-picklist' ); ?>">
						<select name="row-priority" id="cas-pick-priority-<?php echo esc_attr( $order->get_id() ); ?>" onchange="casChangepickPriority(this, '<?php echo esc_attr( $order->get_id() ); ?>');">
							<option value=""><?php echo esc_attr__( 'Select', 'woo-picklist' ); ?></option>	
							<option value="low" <?php echo esc_attr( 'low' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Low', 'woo-picklist' ); ?></option>
							<option value="medium" <?php echo esc_attr( 'medium' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Medium', 'woo-picklist' ); ?></option>
							<option value="high" <?php echo esc_attr( 'high' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'High', 'woo-picklist' ); ?></option>
							<option value="on_hold" <?php echo esc_attr( 'on_hold' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'On Hold', 'woo-picklist' ); ?></option>
						</select>
						<i class="fa-solid fa-fire" style="padding-left:5px; font-size:1rem;padding-top:8px;color:<?php echo esc_attr( $priority_color ); ?>;"></i>
					</td>
					<td data-label="<?php echo esc_attr__( 'Progress:', 'woo-picklist' ); ?>">
						<div class="progressbar" name="cas-progress" id="cas-progress-<?php echo esc_attr( $order->get_id() ); ?>" data-working="<?php echo esc_attr( $in_pick_progress ? 'working' : '' ); ?>" data-progress="<?php echo esc_attr( $progress_value ); ?>"><div class="progress-label"><?php echo esc_attr__( 'Working...', 'woo-picklist' ); ?></div></div>
					</td>
					<td data-label="<?php echo esc_attr__( 'Assigned to:', 'woo-picklist' ); ?>">
						<?php Cas_Pick_Functions::cas_get_pick_list_shop_managers( $order->get_meta( '_cas_pick_admin_user', true ), $order->get_id() ); ?>
					</td>
					<td class="cas-tbl-center" data-label="">
						<a href="<?php echo esc_url( $url . '&tab=single&orderid=' . $order->get_id() . '&tbl=main' ); ?>" class="button">
							<i class="fa-solid fa-square-plus" style="padding-right:5px;color:<?php echo esc_attr( $priority_color ); ?>;"></i><?php echo esc_attr__( 'Pick Order', 'woo-picklist' ); ?>
						</a>
					</td>
				</tr>

				<?php
			}

		}
		?>
		</tbody>
		<tfoot>
			<tr>
				<?php for ( $i = 0; $i <= $col_count; $i++ ) : ?>
					<td style="text-align:center;font-size:small;"></td>
				<?php endfor; ?>
			</tr>
		</tfoot>
		</table>

		<div class="cas-paging-bottom">
			<?php if ( count( $orders['orders'] ) > 0 ) : ?>
				<?php Cas_Pick_Functions::cas_get_paging( $page_num, $orders['total_pages'] ); ?>
			<?php endif; ?>
		</div>
		
	</div>
		<?php
	}

}

