<?php
/**
 * Pick List
 *
 * @package picklist
 *
 * Plugin Name: Pick List for WooCommerce
 * Plugin URI: https://woocommerce.com/products/picklist/
 * Description: Optimize your WooCommerce order fulfillment process with real-time pick lists. Streamlines your order management, and ensuring efficiency and accuracy with instant updates.
 * Version: 2.5.13
 * Author: Consortia
 * Author URI: https://www.consortia.no/us/
 * Text Domain: woo-picklist
 * Domain Path: /languages
 *
 * Tested up to: 6.8.2
 * Requires at least: 5.0
 * Requires PHP: 5.6
 * WC requires at least: 3.5
 * WC tested up to: 10.1.1
 *
 * Copyright: © 2018-2025 Consortia AS.
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 * Woo: 18734002841541:6e4d6222154608950df80bd7feb19c3e

 */

/**
 * Current Pick List version 
 */ 
const CAS_WOO_PICKLIST_VS   = '2.5.13';
const CAS_WOO_PICKLIST_PROD = 'true';

add_action( 'before_woocommerce_init', function() {
	if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
} );

register_activation_hook( __FILE__, 'cas_pick_install' );
register_deactivation_hook( __FILE__, 'cas_pick_deactivate' );
register_uninstall_hook( __FILE__, 'cas_pick_uninstall' );

add_action( 'init', function() {
	require_once dirname( __FILE__ ) . '/includes/class-pick-woo.php';
} );


/**
 * Pick List
 */
function cas_pick_main_page(): void {

	if ( class_exists( 'WooCommerce' ) ) {

		/**
		 * Get the main page
		 * 
		 * @since 2.3.1
		 */
		do_action( 'cas_pick_get_main_page' ); // phpcs:ignore WordPress.NamingConventions.ValidHookName.UseUnderscores

	}
}

/**
 * Install
 */
function cas_pick_install() {

	global $wp_version;

	if ( version_compare( $wp_version, '4.6', '<' ) ) {
		wp_die( 'This plugin require WordPress 4.6 or higher.' );
	}

	$picklist_options = array(
		'cas_pick_per_page'                   => '',
		'cas_pick_order_statuses'             => '',
		'cas_pick_order_date_range'           => '',
		'cas_pick_order_shipped'              => '',
		'cas_pick_order_completed'            => '',
		'cas_pick_order_processing'           => '',
		'cas_pick_message_done'               => '',
		'cas_pick_message_shipped'            => '',
		'cas_pick_order_custom1'              => '',
		'cas_pick_order_custom2'              => '',
		'cas_pick_order_custom1_lbl'          => '',
		'cas_pick_order_custom2_lbl'          => '',
		'cas_pick_order_custom1_pick'         => '',
		'cas_pick_order_custom2_pick'         => '',
		'cas_pick_order_custom1_order'        => '',
		'cas_pick_order_custom2_order'        => '',
		'cas_pick_order_hide_category'        => '',
		'cas_pick_show_company'               => '',
		'cas_pick_show_role'                  => '',
		'cas_pick_show_timer'                 => '',
		'cas_pick_timer_minutes'              => '',
		'cas_pick_noti_orders'                => 'yes',
		'cas_pick_noti_changes'               => 'yes',
		'cas_pick_auto_refresh'               => '',
		'cas_pick_site_logo'                  => '',
		'cas_pick_message_slip'               => '',
		'cas_pick_message_slip_on'            => '',
		'cas_pick_start_status'               => '',
		'cas_pick_completed_status'           => '',
		'cas_pick_product_c1'                 => '',
		'cas_pick_product_c1_alt'             => '',
		'cas_pick_product_c1_lbl'             => '',
		'cas_pick_product_c1_is_bar'          => '',
		'cas_pick_product_c2'                 => '',
		'cas_pick_product_c2_type'            => '',
		'cas_pick_product_c2_lbl'             => '',
		'cas_pick_barcode_type'               => '',
		'cas_pick_scan_only_in'               => '',
		'cas_pick_scan_sound_on'              => '',
		'cas_pick_my_order_statuses'          => '',
		'cas_show_billing_prints'             => '',
		'cas_pick_ordering'                   => '',
		'cas_pending_pick_ordering'           => '',
		'cas_pending_pick_per_page'           => '',
		'cas_pending_pick_order_statuses'     => '',
		'cas_pending_pick_order_date_range'   => '',
		'cas_pick_scan_all_qty'               => '',
		'cas_include_grid_pick_view'          => '',
		'cas_pick_custom_product_field_1'     => '',
		'cas_pick_custom_product_field_1_lbl' => '',
		'cas_pick_custom_product_field_1_use' => '',
		'cas_pick_custom_product_field_2'     => '',
		'cas_pick_custom_product_field_2_lbl' => '',
		'cas_pick_custom_product_field_2_use' => '',
		'cas_pick_disable_customer_messages'  => '',
		'cas_pick_hide_price_users'           => '',
		'cas_show_shipping_information'       => '',
		'cas_pick_custom_product_field_3'     => '',
		'cas_pick_custom_product_field_3_lbl' => '',
		'cas_pick_custom_product_field_3_use' => '',
		'cas_pick_custom_product_field_4'     => '',
		'cas_pick_custom_product_field_4_lbl' => '',
		'cas_pick_custom_product_field_4_use' => '',
		'cas_use_dark_mode'                   => '',
		'cas_hide_next_unpicked_btn'          => '',
		'cas_hide_th_stock'                   => '',
		'cas_hide_th_price'                   => '',
		'cas_hide_th_weight'                  => '',
		'cas_show_th_dimensions'              => '',
		'cas_shipping_label_paper_size'       => '',
		'cas_shipping_carrier_barcode_format' => '',
		'cas_shipping_include_pick_qr'        => '',
		'cas_hide_shipping_label_button'      => '',
		'cas_picklist_roles'                  => '',
		'cas_pick_regular_product_fields'	  => '',
	);

	update_option( 'picklist_options', $picklist_options );
	set_transient( 'cas-pick-admin-notice-activated', true );
	flush_rewrite_rules();

}

/**
 * Deactivate
 */
function cas_pick_deactivate() {
	flush_rewrite_rules();
}

/**
 * Uninstall
 */
function cas_pick_uninstall() {
	delete_option( 'picklist_options' );
}

