<?php
/**
 * Pick List
 *
 * @package picklist/includes
 */

defined( 'ABSPATH' ) || exit;

const CAS_PICK_UNPICKED = 'Cas_Pick_Unpicked';

/**
 * Class for unpicked orders
 */
class Cas_Pick_Unpicked {

	/**
	 * Get change status dialog
	 */
	public static function cas_get_status_dialog() {
		?>
		<div id="cas-change-status-dialog" title="<?php echo esc_attr__( 'Change Order Status', 'woo-picklist' ); ?>" style="display:none;">
			<form id="change-status-form">
				<label for="order-status"><?php echo esc_html__( 'Select Order Status:', 'woo-picklist' ); ?></label>
				<select name="cas-order-status-select" id="cas-order-status-select">
					<?php
					$statuses = wc_get_order_statuses();
					foreach ( $statuses as $status_slug => $status_name ) {
						echo '<option value="' . esc_attr( $status_slug ) . '">' . esc_html( $status_name ) . '</option>';
					}
					?>
				</select>
			</form>
		</div>
		<?php
	}

	/**
	 * Get unpicked items
	 */
	public static function cas_tab_unpicked() {

		$status_filter   = ( ! empty( filter_input( 1, 'status', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? explode( ',', filter_input( 1, 'status', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) : array();
		$pri_filter      = ( ! empty( filter_input( 1, 'priority', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? explode( ',', filter_input( 1, 'priority', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) : array();
		$progress_filter = ( ! empty( filter_input( 1, 'progress', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? explode( ',', filter_input( 1, 'progress', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) : array();
		$page_num        = ( ! empty( filter_input( 1, 'paged', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? filter_input( 1, 'paged', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) : 1;
		$users_filter    = ( ! empty( filter_input( 1, 'users', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? explode( ',', filter_input( 1, 'users', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) : array();	
		$orders          = Cas_Pick_Functions::cas_get_unpicked_orders( $status_filter, 0 );
		$date_format     = get_option( 'date_format' );
		$time_format     = get_option( 'time_format' );
		$currency_pos    = get_option( 'woocommerce_currency_pos' );
		$url             = admin_url( 'admin.php?page=picklist' );
		$url_order       = admin_url( 'post.php?post=' );
		$url_c_orders    = admin_url( 'admin.php?page=picklist&tab=customers&customer=' );
		$order_statuses  = wc_get_order_statuses();
		$search_str      = ( ! empty( filter_input( 1, 's', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) ) ) ? filter_input( 1, 's', FILTER_SANITIZE_FULL_SPECIAL_CHARS ) : '';
		$options         = get_option( 'picklist_options' );
		
		// Sort
		asort( $order_statuses );

		/**
		 * Filter whether to hide prices for the current user.
		 *
		 * This filter checks if the current user should have prices hidden
		 * based on the 'picklist_options' settings in the database.
		 * 
		 * @since vs 2.4.25
		 *
		 * @param bool $hide Whether to hide prices for the user (default: false).
		 * @return bool
		 */		
		$hide_prices = apply_filters( 'cas_pick_hide_prices_for_user', false );

		?>
		<div class="woo-picklist-container">
		
		<?php self::cas_get_status_dialog(); ?>

		<div class="cas-head-timer-search">
			<div class="cas-order-summary">
				<i class="fa-solid fa-circle-info" title="<?php echo esc_attr__( 'Totals for visible orders (on load, filtered and paging)', 'woo-picklist' ); ?>"></i> 
				<?php echo esc_attr__( 'Orders', 'woo-picklist' ); ?>: <span id="order-rows" class="cas-top-number"></span> | 
				<?php echo esc_attr__( 'Products', 'woo-picklist' ); ?>: <span id="total-items" class="cas-top-number"></span> | 
				<?php echo esc_attr__( 'Orders Total Value', 'woo-picklist' ); ?>: <span id="total-value" class="cas-top-number" data-currency-pos="<?php echo esc_attr( $currency_pos ); ?>" data-currency-symbol="<?php echo esc_attr( get_woocommerce_currency_symbol() ); ?>"></span> | 
				<?php echo esc_attr__( 'Average Order Value', 'woo-picklist' ); ?>: <span id="average-value" class="cas-top-number"></span> |
				<?php echo esc_attr__( 'Shipping Total', 'woo-picklist' ); ?>: <span id="shipping-value" class="cas-top-number"> <i class="fa-solid fa-sack-dollar" title="<?php echo esc_attr__( 'Click totals to see', 'woo-picklist' ); ?>"></i> </span> |
				<?php echo esc_attr__( 'Average Shipping', 'woo-picklist' ); ?>: <span id="shipping-average-value" class="cas-top-number"> <i class="fa-solid fa-sack-dollar" title="<?php echo esc_attr__( 'Click totals to see', 'woo-picklist' ); ?>"></i> </span>
				<?php if ( ! $hide_prices ) : ?>
					<span class="cas-top-btn-totals"><button class="button" id="cas-get-pending-totals" onclick="casGetOrderTotals('pending');" title="<?php echo esc_attr__( 'Get totals for all orders (statuses and date range from settings)', 'woo-picklist' ); ?>"><i class="fa-solid fa-chart-simple"></i></button></span>				
				<?php endif; ?>
				<span name="cas-timer-display" class="cas-timer" data-timer-message="<?php echo esc_attr__( 'to update', 'woo-picklist' ); ?>" data-timer-minutes="<?php echo esc_attr( $options['cas_pick_timer_minutes'] ); ?>" data-timer-show="<?php echo esc_attr( $options['cas_pick_show_timer'] ); ?>"></span>
			</div>
			<div class="cas-search-form">
				<span>
					<form method="get" autocomplete="off" action="<?php echo esc_attr( $url ); ?>"> 
					<input type="hidden" name="page" value="picklist">
					<input type="hidden" name="tab" value="unpicked">
					<input type="search" name="s" value="<?php echo esc_attr( $search_str ); ?>">
					<button type="submit" class="button"><i class="fa-solid fa-magnifying-glass"></i> <?php echo esc_attr__( 'Search', 'woo-picklist' ); ?></button>
					</form>
				</span>
			</div>
		</div>
		
		<div class="cas-pick-order-filters">
			<div>
				<div class="cas-order-filter" style="padding-right:10px;">
				<form method="get" action="admin.php" id="cas-order-filter-form" onsubmit="casDoOrderFilter(this);">
					<input type="hidden" name="page" value="picklist">
					<input type="hidden" name="tab" value="unpicked">
					<input type="hidden" name="status" id="cas-selected-filters" value="">
					<input type="hidden" name="priority" id="cas-selected-priorities" value="">
					<input type="hidden" name="progress" id="cas-selected-progress" value="">
					<input type="hidden" name="users" id="cas-selected-users" value="">
					<select name="order-filter" id="cas-select-order-filter" multiple="multiple" size="5" onchange="casFilterByStatus();">
						<?php 
						foreach ( $order_statuses as $key => $value ) : 
							?>
							<option value="<?php echo esc_attr( $key ); ?>" <?php echo esc_attr( in_array( $key, $status_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr( $value ); ?></option>
						<?php endforeach; ?>
					</select>
					<button type="submit" class="button" title="<?php echo esc_attr__( 'Filter by order statuses', 'woo-picklist' ); ?>"> <i class="fa-solid fa-filter"></i> </button>
				</form>
				</div>
				<div class="cas-order-filter" style="padding-right:10px;">
					<select id="cas-pick-priority-filter" multiple="multiple" size="5" onchange="casFilterByPriority();">
						<option value="low" <?php echo esc_attr( in_array( 'low', $pri_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Low', 'woo-picklist' ); ?></option>
						<option value="medium" <?php echo esc_attr( in_array( 'medium', $pri_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Medium', 'woo-picklist' ); ?></option>
						<option value="high" <?php echo esc_attr( in_array( 'high', $pri_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'High', 'woo-picklist' ); ?></option>
						<option value="on_hold" <?php echo esc_attr( in_array( 'on_hold', $pri_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'On Hold', 'woo-picklist' ); ?></option>
					</select>
					<button class="button" onclick="casDoPriorityFilter();" title="<?php echo esc_attr__( 'Filter by priority', 'woo-picklist' ); ?>"> <i class="fa-solid fa-filter"></i> </button>
				</div>
			</div>
			<div>
				<div class="cas-order-filter" style="padding-right:10px;">
					<select id="cas-pick-progress-filter" multiple="multiple" size="3" onchange="casFilterByProgress();">
						<option value="null" <?php echo esc_attr( in_array( 'null', $progress_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Not Started', 'woo-picklist' ); ?></option>
						<option value="ongoing" <?php echo esc_attr( in_array( 'ongoing', $progress_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'In Progress', 'woo-picklist' ); ?></option>
						<option value="done" <?php echo esc_attr( in_array( 'done', $progress_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Done', 'woo-picklist' ); ?></option>
					</select>
					<button class="button" onclick="casFilterProgress();" title="<?php echo esc_attr__( 'Filter by progress', 'woo-picklist' ); ?>"> <i class="fa-solid fa-filter"></i> </button>
				</div>
				<div class="cas-order-filter" style="padding-right:10px;">
					<select id="cas-pick-users-filter" multiple="multiple" size="3" onchange="casFilterByUser();">
					<?php 
					foreach ( Cas_Pick_Functions::cas_get_pick_list_users() as $pick_user ) : 
						?>
						<option value="<?php echo esc_attr( $pick_user->user_login ); ?>" <?php echo esc_attr( in_array( $pick_user->user_login, $users_filter, true ) ? 'selected="selected"' : '' ); ?>><?php echo esc_attr( $pick_user->display_name ); ?></option>
					<?php endforeach; ?>
					</select>
					<button class="button" onclick="casFilterUsers();" title="<?php echo esc_attr__( 'Filter by user', 'woo-picklist' ); ?>"> <i class="fa-solid fa-filter"></i> </button>
				</div>
			</div>
			<div>	
				<div class="cas-order-filter" style="padding-bottom:2px;">
					<button class="button" onclick="casResetFilters();" title="<?php echo esc_attr__( 'Reset all filters', 'woo-picklist' ); ?>"><i class="fa-solid fa-rotate-left"></i> <?php echo esc_attr__( 'Reset', 'woo-picklist' ); ?></button>
					<button class="button" onclick="casExportPickList('cas-pick-order-table');" title="<?php echo esc_attr__( 'Export List', 'woo-picklist' ); ?>" style="margin-left:5px;"><i class="fa-solid fa-file-arrow-down"></i></button>
				</div>
			</div>	
		
			<div style="padding-bottom: 14px;text-align:right;flex-grow:4;">
				<?php Cas_Pick_Functions::cas_get_paging( $page_num, $orders->max_num_pages ); ?>
			</div>
		</div>
		
		<?php $col_count = 2; ?>
		<?php wp_nonce_field( 'cas_pick_id' ); ?>
		<div class="cas-div-table-container">
		<table id="cas-pick-order-table" class="widefat striped posts cas-pick-table cas-orders-list" style="width:100%;">
			<thead>
				<tr>
				<th><a href="#" onclick="casSortCol(0,'number','s','cas-pick-order-table');"><i id="s0" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Order ID', 'woo-picklist' ); ?></a></th>
				<th><a href="#" onclick="casSortCol(1,'date','s','cas-pick-order-table');"><i id="s1" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Date', 'woo-picklist' ); ?></a></th>
				<th><a href="#" onclick="casSortCol(2,'text','s','cas-pick-order-table');"><i id="s2" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Customer', 'woo-picklist' ); ?></a></th>
				<?php 
				if ( 'yes' === $options['cas_pick_show_company'] ) :
					?>
					<?php $col_count++; ?>
					<th><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Company', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<?php 
				if ( 'yes' === $options['cas_pick_show_role'] ) : 
					?>
					<?php $col_count++; ?>
					<th><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Role', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<th><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Status', 'woo-picklist' ); ?></a></th>
				<th id="cas-th-items" class="cas-tbl-center" style="text-align:center;"><?php $col_count++; ?>
					<a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'number','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Items', 'woo-picklist' ); ?></a>
				</th>
				<?php if ( ! $hide_prices ) : ?>
					<th id="cas-th-total" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'number','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Total', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_show_shipping_information'] ) : ?>
					<?php $col_count++; ?>
					<th id="cas-th-shipping" style="text-align:left;"><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Shipping', 'woo-picklist' ); ?></a></th>
				<?php endif; ?>
				<?php 
				if ( 'yes' === $options['cas_pick_order_custom1_pick'] && strlen( $options['cas_pick_order_custom1'] ) > 0 ) : 
					?>
					<?php $col_count++; ?>
					<th><?php echo esc_attr( $options['cas_pick_order_custom1_lbl'] ); ?></th>
				<?php endif; ?>
				<?php 
				if ( 'yes' === $options['cas_pick_order_custom2_pick'] && strlen( $options['cas_pick_order_custom2'] ) > 0 ) : 
					?>
					<?php $col_count++; ?>
					<th><?php echo esc_attr( $options['cas_pick_order_custom2_lbl'] ); ?></th>
				<?php endif; ?>
				<th class="cas-th-pick"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Priority', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick cas-tbl-center" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'progress','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Progress', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick cas-tbl-center" style="text-align:center;"><?php $col_count++; ?><a href="#" onclick="casSortCol(<?php echo esc_attr( $col_count ); ?>,'text','s','cas-pick-order-table');"><i id="s<?php echo esc_attr( $col_count ); ?>" class="fas fa-sort cas-i-space"></i><?php echo esc_attr__( 'Assigned to', 'woo-picklist' ); ?></a></th>
				<th class="cas-th-pick"><?php $col_count++; ?></th>
			</tr>
			</thead>
		<tbody>
		<?php 
		
		foreach ( $orders->orders as $order ) {

			$customer_name  = ( null !== $order->get_billing_first_name() && null !== $order->get_billing_last_name() ) ? $order->get_billing_first_name() . ' ' . $order->get_billing_last_name() : '';
			$progress_value = '0';
			$picked_items   = $order->get_meta( '_cas_pick_order_status_qty', true );
			$pick_percent   = $order->get_meta( '_cas_pick_order_status_percent', true );
			$pick_priority  = $order->get_meta( '_cas_pick_order_priority', true );
			$shipped_count  = ( ! empty( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) && intval( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) > 0 ) ? intval( $order->get_meta( '_cas_pick_order_shipped_count', true ) ) : 0;
			
			if ( ! empty( $pick_percent ) ) {
				$progress_value = intval( $pick_percent );
			} else {
				$pick_percent = 0;
			}

			$priority_color   = Cas_Pick_Functions::cas_get_priority_status_color( $pick_priority );
			$in_pick_progress = false;

			if ( is_array( $picked_items ) ) {
				foreach ( array_values( $picked_items ) as $value ) {
					if ( ! empty( $value ) ) {
						$in_pick_progress = true;
						break;
					}	
				}
			}

			?>
			<tr data-url="<?php echo esc_url( $url . '&tab=single&orderid=' . $order->get_id() . '&tbl=unpicked' ); ?>">
				<td data-label="<?php echo esc_attr__( 'ID:', 'woo-picklist' ); ?>"><a href="<?php echo esc_url( $url_order . $order->get_id() . '&action=edit' ); ?>"><?php echo esc_attr( $order->get_order_number() ); ?></a></td>
				<td data-label="<?php echo esc_attr__( 'Date:', 'woo-picklist' ); ?>">
					<?php echo esc_attr( date_format( new DateTime( $order->get_date_created() ), $date_format ) ); ?><br/>
					<span class="cas-span-smaller"><i class="fa-regular fa-clock"></i> <?php echo esc_attr( date_format( new DateTime( $order->get_date_created() ), $time_format ) ); ?></span>
				</td>
				<td data-label="<?php echo esc_attr__( 'Customer:', 'woo-picklist' ); ?>">
					<a href="<?php echo esc_url( $url_c_orders . ( ( $order->get_customer_id() > 0 ) ? $order->get_customer_id() : $order->get_billing_email() ) ); ?>" title="<?php echo esc_attr__( 'Click to view this customers orders', 'woo-picklist' ); ?>">
						<?php echo esc_attr( $customer_name ); ?>
					</a>
				</td>
				<?php if ( 'yes' === $options['cas_pick_show_company'] ) : ?>
					<td data-label="<?php echo esc_attr__( 'Company:', 'woo-picklist' ); ?>"><?php echo esc_attr( null !== $order->get_billing_company() ? $order->get_billing_company() : ''  ); ?></td>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_pick_show_role'] ) : ?>
					<td data-label="<?php echo esc_attr__( 'Role:', 'woo-picklist' ); ?>"><?php echo esc_attr( $order->get_customer_id() ? Cas_Pick_Functions::cas_get_customer_role( $order->get_customer_id() ) : '' ); ?></td>
				<?php endif; ?>
				<td data-label="<?php echo esc_attr__( 'Status:', 'woo-picklist' ); ?>">
					<i class="fa-solid fa-pen-to-square" onclick="casChangeOrderStatus(this,'<?php echo esc_attr( $order->get_id() ); ?>');" id="cas-change-status-icon" style="color:black;font-size:small;margin-right:2px;" title="<?php echo esc_attr__( 'Change Order Status', 'woo-picklist' ); ?>"></i>
					<span id="cas-current-order-status-<?php echo esc_attr( $order->get_id() ); ?>" class="order-status status-<?php echo esc_attr( $order->get_status() ); ?>"><?php echo esc_attr( wc_get_order_status_name( $order->get_status() ) ); ?></span>
					<?php if ( 'yes' === $order->get_meta( '_cas_pick_order_shipped', true ) ) : ?>
						<i class="fa-solid fa-truck-arrow-right" style="font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Order is shipped', 'woo-picklist' ); ?>"></i>
						<?php if ( ( $shipped_count > 0 && 100.00 !== floatval( $pick_percent ) ) || ( $shipped_count > 1 && 100.00 === floatval( $pick_percent ) ) ) : ?>
							<span class="cas-count-badge-list" title="<?php echo esc_attr__( 'Shipped count', 'woo-picklist' ); ?>"><?php echo esc_attr( $shipped_count ); ?></span>
						<?php endif; ?>
					<?php endif; ?>
					<?php if ( ( 0 !== intval( $progress_value ) && 100 > intval( $progress_value ) ) || ( $in_pick_progress && 100 > intval( $progress_value ) ) ) : ?>
						<i class="fa-solid fa-people-carry-box cas-blink" style="color:darkorange;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Working', 'woo-picklist' ); ?>"></i>
					<?php endif; ?>
					<?php if ( $in_pick_progress && 0 === intval( $progress_value ) ) : ?>
						<i class="fa-solid fa-barcode cas-blink" style="color:black;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'Scanning', 'woo-picklist' ); ?>"></i>
					<?php endif; ?>
					<?php if ( 0 === intval( $progress_value ) && strlen( $order->get_meta( '_cas_pick_admin_user', true ) ) > 0 && ! $in_pick_progress ) : ?>
						<i class="fa-solid fa-user-lock" style="color:gray;font-size:medium;margin-left:10px;" title="<?php echo esc_attr__( 'User assigned', 'woo-picklist' ); ?>"></i>
					<?php endif; ?>
				</td>
				<td class="cas-tbl-center" data-label="<?php echo esc_attr__( 'Items:', 'woo-picklist' ); ?>" data-items="items"><?php echo esc_attr( $order->get_item_count() ); ?></td>
				<?php if ( ! $hide_prices ) : ?>
					<td class="cas-tbl-center" data-label="<?php echo esc_attr__( 'Total:', 'woo-picklist' ); ?>" data-total="total"><?php echo wp_kses( wc_price( $order->get_total() ), 'post' ); ?></td>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_show_shipping_information'] ) : ?>
					<td data-label="<?php echo esc_attr__( 'Shipping:', 'woo-picklist' ); ?>">
						<span class="cas-span-shipping-method"><?php echo esc_attr( ! empty( $order->get_shipping_method() ) ? $order->get_shipping_method() : '-' ); ?></span>
						<?php if ( ! $hide_prices ) : ?>
							<br/><span class="cas-span-smaller"><?php echo wp_kses( wc_price( $order->get_shipping_total() ), 'post' ); ?></span>
						<?php endif; ?>
					</td>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_pick_order_custom1_pick'] && strlen( $options['cas_pick_order_custom1'] ) > 0 ) : ?>
					<td data-label=""><?php echo esc_attr( $order->get_meta( $options['cas_pick_order_custom1'] ) ); ?></td>
				<?php endif; ?>
				<?php if ( 'yes' === $options['cas_pick_order_custom2_pick'] && strlen( $options['cas_pick_order_custom2'] ) > 0 ) : ?>
					<td data-label=""><?php echo esc_attr( $order->get_meta( $options['cas_pick_order_custom2'] ) ); ?></td>
				<?php endif; ?>
				
				<td data-label="<?php echo esc_attr__( 'Priority:', 'woo-picklist' ); ?>">
					<select name="row-priority" id="cas-pick-priority-<?php echo esc_attr( $order->get_id() ); ?>" onchange="casChangepickPriority(this, '<?php echo esc_attr( $order->get_id() ); ?>');">
						<option value=""><?php echo esc_attr__( 'Select', 'woo-picklist' ); ?></option>	
						<option value="low" <?php echo esc_attr( 'low' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Low', 'woo-picklist' ); ?></option>
						<option value="medium" <?php echo esc_attr( 'medium' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'Medium', 'woo-picklist' ); ?></option>
						<option value="high" <?php echo esc_attr( 'high' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'High', 'woo-picklist' ); ?></option>
						<option value="on_hold" <?php echo esc_attr( 'on_hold' === $pick_priority ? 'selected="selected"' : '' ); ?>><?php echo esc_attr__( 'On Hold', 'woo-picklist' ); ?></option>
					</select>
					<i class="fa-solid fa-fire" style="padding-left:5px; font-size:1rem;padding-top:8px;color:<?php echo esc_attr( $priority_color ); ?>;"></i>
				</td>
				<td data-label="<?php echo esc_attr__( 'Progress:', 'woo-picklist' ); ?>">
					<div class="progressbar" name="cas-progress" id="cas-progress-<?php echo esc_attr( $order->get_id() ); ?>" data-working="<?php echo esc_attr( $in_pick_progress ? 'working' : '' ); ?>" data-progress="<?php echo esc_attr( $progress_value ); ?>"><div class="progress-label"><?php echo esc_attr__( 'Working...', 'woo-picklist' ); ?></div></div>
				</td>
				<td data-label="<?php echo esc_attr__( 'Assigned to:', 'woo-picklist' ); ?>">
					<?php Cas_Pick_Functions::cas_get_pick_list_shop_managers( $order->get_meta( '_cas_pick_admin_user', true ), $order->get_id() ); ?>
				</td>
				<td class="cas-tbl-center" data-label="">
					<a href="<?php echo esc_url( $url . '&tab=single&orderid=' . $order->get_id() . '&tbl=unpicked' ); ?>" class="button"><i class="fa-solid fa-square-plus" style="padding-right:5px;color:<?php echo esc_attr( $priority_color ); ?>;"></i><?php echo esc_attr__( 'Pick Order', 'woo-picklist' ); ?></a>
				</td>
			</tr>

			<?php
		}

		?>
		</tbody>
		<tfoot>
			<tr>
				<?php for ( $i = 0; $i <= $col_count; $i++ ) : ?>
					<td style="text-align:center;font-size:small;"></td>
				<?php endfor; ?>
			</tr>
			</tr>
		</tfoot>
		</table>

		<div class="cas-paging-bottom">
			<?php Cas_Pick_Functions::cas_get_paging( $page_num, $orders->max_num_pages ); ?>
		</div>
		
	</div>
		<?php
	}

}


