<?php

class WC_EPG_ParsePaymentSessionData {

	public static function createPaymentSessionData( array $data ): ?WC_EPG_PaymentSessionData {
		if ( ! $data['value'] ) {
			return null;
		}

		$parsed_data = [];
		$pairs = explode(',', $data['value']);

		foreach ( $pairs as $pair ) {
			list( $key, $value ) = explode(':', $pair, 2);
			$parsed_data[$key] = $value;
		}

		return new WC_EPG_PaymentSessionData( $parsed_data );
	}

	public static function rebuildMetaString( $parsed_data ) {
		$pairs = [];

		foreach ( $parsed_data as $key => $value ) {
			$pairs[] = $key . ':' . $value;
		}
		return implode(',', $pairs);
	}
}
