<?php

class WC_EPG_Cron_Handler {

	public function __construct() {
		add_action( 'epg_checking_payment_status', array( $this, 'check_payment_status' ) );
	}

	public function check_payment_status() {
		wgc_log('CHECK PAYMENT STATUS STARTING');
		if ( ! wgc_get_option( WGC_KEY_PAYMENT_STATUS_FETCH_ENABLED ) ) {
			return;
		}

		$orderLimit = wgc_get_option( WGC_KEY_PAYMENT_STATUS_FETCH_LIMIT );
		$daysToCheck = wgc_get_option( WGC_KEY_PAYMENT_STATUS_FETCH_TIME );

		$orders = wc_get_orders(
			array(
				'status' => 'pending',
				'limit' => $orderLimit,
				'payment_method' => wgc_get_payment_name(),
				'date_created' => '>' . gmdate('Y-m-d', strtotime("-{$daysToCheck} days"))
			)
		);

		foreach ( $orders as $order ) {
			epg_checkAndUpdateOrderStatus( $order );
		}
		wgc_log('CHECK PAYMENT STATUS DONE');
	}
}
new WC_EPG_Cron_Handler();
