<?php

use Elavon\Converge2\Handler\ResponseHandlerInterface;
use Elavon\Converge2\Response\ResponseInterface;

class WC_Gateway_Converge_Response_Log_Handler implements ResponseHandlerInterface {

	/** 
	 * Request Type.
	 * 
	 * @var string 
	 */
	protected $requestType;

	public function __construct( $requestType = '' ) {
		$this->withRequestType( $requestType );
	}

	/**
	 * Function to set and return the request type.
	 * 
	 * @param string $requestType
	 *
	 * @return $this
	 */
	public function withRequestType( $requestType ) {
		$this->requestType = $requestType;

		return $this;
	}

	public function handle( ResponseInterface $response ) {
		wgc_log_converge_response( $response, $this->requestType );
	}
}
