/*global elavon_converge_gateway */
const accountFieldsIds = [
	'woocommerce_elavon-converge-gateway_processor_account_id',
	'woocommerce_elavon-converge-gateway_merchant_alias',
	'woocommerce_elavon-converge-gateway_public_key',
	'woocommerce_elavon-converge-gateway_secret_key',
	'woocommerce_elavon-converge-gateway_environment',
];
const initialValues = [];
storeInitialValues();
if (!allFieldsEmpty()) {
	const saveButton = document.getElementsByName('save')[0];
	saveButton.addEventListener('click', settingsConfirmation);
}

jQuery(function ($) {
	const enableSavePaymentMethods = $(
		'#woocommerce_elavon-converge-gateway_enable_save_payment_methods'
	);
	const enableSubscriptions = $(
		'#woocommerce_elavon-converge-gateway_enable_subscriptions'
	);

	enableSubscriptions.change(function () {
		enableSubscriptionsCheckboxFunctionality(
			$(this),
			enableSavePaymentMethods
		);
	});

	enableSubscriptionsCheckboxFunctionality(
		enableSubscriptions,
		enableSavePaymentMethods
	);

	enableSavePaymentMethods.click(function () {
		const attr = $(this).attr('readonly');
		if (typeof attr !== typeof undefined && attr !== false) {
			return false;
		}
	});
});

function enableSubscriptionsCheckboxFunctionality(
	enableSubscriptionsCheckbox,
	enableSavePaymentMethodsCheckbox
) {
	if (enableSubscriptionsCheckbox.is(':checked')) {
		enableSavePaymentMethodsCheckbox.attr('readonly', 'readonly');

		if (!enableSavePaymentMethodsCheckbox.is(':checked')) {
			enableSavePaymentMethodsCheckbox.prop('checked', true);
		}
	} else {
		enableSavePaymentMethodsCheckbox.removeAttr('readonly');
	}
}

function settingsConfirmation(event) {
	let isAccountChanged = false;

	for (let index = 0; index < accountFieldsIds.length; index++) {
		if (
			initialValues[accountFieldsIds[index]] !==
			document.getElementById(accountFieldsIds[index]).value
		) {
			isAccountChanged = true;
			break;
		}
	}

	if (isAccountChanged) {
		// eslint-disable-next-line no-alert, camelcase
		if (window.confirm(elavon_converge_gateway.delete_alert)) {
		} else {
			event.preventDefault();
			window.location.href = window.location.href;
		}
	}
}

function allFieldsEmpty() {
	let allEmpty = true;
	for (let index = 0; index < accountFieldsIds.length; index++) {
		if (initialValues[accountFieldsIds[index]] !== '') {
			allEmpty = false;
		}
	}

	return allEmpty;
}

function storeInitialValues() {
	for (let index = 0; index < accountFieldsIds.length; index++) {
		initialValues[accountFieldsIds[index]] = document.getElementById(
			accountFieldsIds[index]
		).value;
	}
}
