<?php

class WC_EPG_PaymentSessionData {

	private $data;

	/**
	 * Constructor for PaymentSessionData object
	 * 
	 * @param $data parsed payment session data
	 */
	public function __construct( $data ) {
		$this->data = $data;
	}

	public function isStatusExpired(): bool {
		return 'expired' == $this->data['status'];
	}

	public function isStatusPaid(): bool {
		return 'paid' == $this->data['status'];
	}

	public function hasExpired(): bool {
		$expiresAt = new DateTime( $this->getExpiresAt() );
		$currentTime = new DateTime();

		return $expiresAt->getTimestamp() > $currentTime->getTimestamp();
	}

	public function getData(): array {
		return $this->data;
	}

	public function getStatus(): string {
		return $this->data['status']; //active; paid; expired;
	}

	public function getId(): string {
		return $this->data['id'];
	}

	public function getExpiresAt(): string {
		return $this->data['expiresAt'];
	}

	public function getCreatedAt(): string {
		return $this->data['createdAt'];
	}

	public function setStatusPaid() {
		$this->data['status'] = 'paid';
	}

	public function setNewStatus( $status ) {
		$this->data['status'] = $status;
	}

	public function setStatusExpired() {
		$this->data['status'] = 'expired';
	}
}
