<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit();
}

class WC_Meta_Box_Wgc_Coupon {

	public static function init() {
		add_action( 'woocommerce_coupon_options', array( __CLASS__, 'display_options' ), 10 );
		add_action( 'woocommerce_coupon_options_save', array( __CLASS__, 'save' ), 10, 2 );
	}

	public static function display_options() {
		include 'views/html-coupon.php';
	}

	public static function save( $post_id, $coupon ) {
		if ( isset($_POST['converge_subscription_type']) && wp_verify_nonce( sanitize_text_field( $_POST['converge_subscription_type'] ), 'woocommerce_meta_nonce' ) ) {
			$props = array( isset( $_POST['converge_subscription_type'] ) ? wc_clean( wp_unslash( $_POST['converge_subscription_type'] ) ) : '' ); // phpcs:ignore WordPress.Security.NonceVerification.Missing

			foreach ( $props as $key => $value ) {
				update_post_meta( $post_id, '_converge_subscription_type', $value );
			}
		}
	}
}

WC_Meta_Box_Wgc_Coupon::init();
