<?php

class WC_Gateway_Converge_Admin_Order_Converge_Status {

	public function __construct() {
		add_action(
			'woocommerce_admin_order_data_after_order_details',
			array(
				$this,
				'checkAndUpdateOrderStatus',
			)
		);

		add_action(
			'woocommerce_admin_order_data_after_order_details',
			array(
				$this,
				'output_status',
			)
		);
	}

	/**
	 * WooCommerce Order.
	 * 
	 * @param WC_Order $order
	 */
	public function output_status() {
		global $theorder; // WC_Order object.
		$order    = $theorder;

		if ( ! $order instanceof WC_Order ) {
			return;
		}

		if ( $order->get_payment_method() != wgc_get_payment_name() ) {
			return; // This order is not a Converge order.
		}

		?>

		<div class="form-field form-field-wide wgc_sync_container">
			<div class="notice inline notice-warning">
				<p><?php esc_html_e( 'The subscription status is not updated. ', 'elavon-converge-gateway' ); ?>
					<a class="wgc_sync" href=""><?php esc_html_e( 'Sync with the Elavon Payment Gateway now.', 'elavon-converge-gateway' ); ?></a>
				</p>
				<input type="hidden" name="wgc_sync_subscription_nonce" id="wgc_sync_subscription_nonce" value="<?php echo esc_attr( wp_create_nonce( 'wgc_sync_subscription_nonce' ) ); ?>"/>
			</div>
		</div>

		<?php

		$converge_transaction_status = wgc_get_order_transaction_state( $order );

		if ( ! empty( $converge_transaction_status ) ) {
			echo wp_kses_post( '<p class="form-field form-field-wide"><label for=""> ' . __( 'Elavon Payment Gateway Transaction Status:', 'elavon-converge-gateway' ) . '</label><span>' . $converge_transaction_status->getValue() . '</span></p>' );
		}

		$unique_transaction_id = $order->get_meta( '_unique_transaction_id', true );

		if ( ! empty( $unique_transaction_id ) ) {
			echo wp_kses_post( '<p class="form-field form-field-wide"><label for=""> ' . __( 'Merchant Transaction Code:', 'elavon-converge-gateway' ) . '</label><span>' . $unique_transaction_id . '</span></p>' );
		}
	}

	public function checkAndUpdateOrderStatus( $order ) {
		$changedStatus = epg_checkAndUpdateOrderStatus( $order );

		if ( $changedStatus && isset( $_SERVER['REQUEST_URI'] ) ) {
			wp_safe_redirect( home_url( esc_url_raw( wp_unslash( $_SERVER['REQUEST_URI'] ) ) ) );
			exit;
		}
	}
}

new WC_Gateway_Converge_Admin_Order_Converge_Status();
