<?php

use Elavon\Converge2\Request\Payload\Validation\Constraint\AbstractConstraint;
use Elavon\Converge2\Request\Payload\Validation\Constraint\Violation\Violation;

class IntroductoryRateBillingPeriods extends AbstractConstraint {
	const ID = 'IntroductoryRateBillingPeriods';

	protected $id                   = self::ID;
	protected $errorMessageTemplate = 'The number of billing periods after a subscription ends must exceed the number of introductory rate billing periods.';
	protected $introductoryRateBillingPeriods;

	public function __construct( $introductoryRateBillingPeriods, $errorMessageTemplate = '' ) {
		$this->introductoryRateBillingPeriods = isset( $introductoryRateBillingPeriods ) ? (int) $introductoryRateBillingPeriods : null;
		parent::__construct( $errorMessageTemplate );
	}

	public function assert( $endingBillingPeriods ) {
		$violations = array();

		if ( $endingBillingPeriods < $this->introductoryRateBillingPeriods ) {
			$violations[] = new Violation(
				$this->id,
				$this->errorMessageTemplate,
				$endingBillingPeriods
			);
		}

		return $violations;
	}
}
