<?php

namespace SkyVerge\WooCommerce\Realex_HPP\Blocks;

use SkyVerge\WooCommerce\PluginFramework\v5_15_9\SV_WC_Payment_Gateway;
use SkyVerge\WooCommerce\PluginFramework\v5_15_9\SV_WC_Payment_Gateway_Plugin;
use SkyVerge\WooCommerce\PluginFramework\v5_15_9\Payment_Gateway\Blocks\Gateway_Checkout_Block_Integration;

/**
 * Checkout block integration class.
 *
 * @since 3.3.0
 *
 * @property \WC_Realex_Redirect $plugin
 * @property \WC_Gateway_Realex_Redirect $gateway
 */
class Checkout_Block_Integration extends Gateway_Checkout_Block_Integration {


	/**
	 * Adds payment method data.
	 *
	 * @since 3.3.0
	 *
	 * @param array<string, mixed> $payment_method_data
	 * @param \WC_Gateway_Realex_Redirect $gateway
	 * @return array<string, mixed>
	 */
	public function add_payment_method_data( array $payment_method_data, SV_WC_Payment_Gateway $gateway ) : array {

		$payment_method_data['gateway'] = array_merge(
			$payment_method_data['gateway'] ?: [],
			[
				'merchant_id'         => $gateway->get_merchant_id(),
				'sub_account'         => $gateway->get_subaccount(),
				'alt_payment_methods' => $gateway->get_available_payment_methods(),
				'form'            => [
					'pay_page_url' => $gateway->get_hosted_pay_page_url(),
					'return_url'   => $gateway->get_return_url(),
					'type'         => $gateway->get_form_type(),
					'language'     => $gateway->get_form_language(),
				],
			]
		);

		$payment_method_data['flags'] = array_merge(
			$payment_method_data['flags'] ?: [],
			[
				'avs_enabled' => $gateway->is_avs_enabled(),
				'apm_enabled' => $gateway->is_apm_enabled(),
			]
		);

		return $payment_method_data;
	}


}
