<?php
/**
 * WooCommerce Global Payments HPP
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@skyverge.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Global Payments HPP to newer
 * versions in the future. If you wish to customize WooCommerce Global Payments HPP for your
 * needs please refer to https://docs.woocommerce.com/document/woocommerce-global-payments/ for more information.
 *
 * @author      SkyVerge
 * @copyright   Copyright (c) 2012-2022, SkyVerge, Inc.
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace SkyVerge\WooCommerce\Realex_HPP\Admin;

defined( 'ABSPATH' ) or exit;

/**
 * The Admin handler.
 *
 * @since 3.0.0
 */
class Admin {


	/**
	 * Constructs the class.
	 *
	 * @since 3.0.0
	 */
	public function __construct() {

		add_action( 'admin_notices', [ $this, 'add_admin_notices' ] );
	}


	/**
	 * Adds admin notices.
	 *
	 * @internal
	 *
	 * @since 3.0.0
	 */
	public function add_admin_notices() {

		if ( 'yes' === get_option( 'wc_realex_redirect_migrated_from_direct' ) ) {
			$this->add_migration_complete_notice();
		}
	}


	/**
	 * Adds a notice informing the merchant that the migration is complete.
	 *
	 * @since 3.0.0
	 */
	protected function add_migration_complete_notice() {

		$message = sprintf(
			/* translators: Placeholders: %1$s - <strong> tag, %2$s - </strong> tag, %3$s - <a> tag, %4$s - </a> tag */
			__( '%1$sThanks for migrating to Global Payments HPP!%2$s You\'re all set to receive payments. %3$sClick here to learn more about this payment gateway%4$s.', 'woocommerce-gateway-realex-redirect' ),
			'<strong>', '</strong>',
			'<a href="' . wc_realex_redirect()->get_documentation_url() . '" target="_blank">', '</a>'
		);

		wc_realex_redirect()->get_admin_notice_handler()->add_admin_notice( $message, 'wc-realex-redirect-migration-completed', [
			'dismissible' => true,
		] );
	}


}
