<?php
/**
 * WooCommerce Memberships
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@skyverge.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Memberships to newer
 * versions in the future. If you wish to customize WooCommerce Memberships for your
 * needs please refer to https://docs.woocommerce.com/document/woocommerce-memberships/ for more information.
 *
 * @author    SkyVerge
 * @copyright Copyright (c) 2014-2024, SkyVerge, Inc. (info@skyverge.com)
 * @license   http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

defined( 'ABSPATH' ) or exit;

/**
 * Membership renewal reminder email
 *
 * @type string $email_heading Email heading
 * @type string $email_body Email body
 * @type string $additional_content Additional content to be added to the email
 * @type \WC_Memberships_User_Membership $user_membership User Membership
 *
 * @version 1.25.0
 * @since 1.7.0
 */

echo $email_heading . "\n\n";

echo "----------\n\n";

echo wptexturize( $email_body );

echo "----------\n\n";

if ( $additional_content ) {
	echo wptexturize( $additional_content ) . "\n\n";
}

echo (string) apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text', '' ) );
