<?php

namespace Ademti\WoocommerceMsrp\Integrations;

use WC_Product;
use function get_woocommerce_currency;
use function number_format;

class WoocommerceProductFeeds {
	/**
	 * Add filters.
	 */
	public function run() {
		add_filter( 'woocommerce_gpf_custom_field_list', [ $this, 'register_field' ] );
	}

	/**
	 * Register the field so it can be chosen as a prepopulate option.
	 *
	 * @param  array  $field_list
	 *
	 * @return array
	 * @throws \Exception
	 */
	public function register_field( array $field_list ): array {
		$field_list['method:woocommerce_msrp_woocommerce_product_feeds_integration::get_msrp'] =
			__( 'MSRP from MSRP Pricing extension', 'woocommerce_msrp' );

		return $field_list;
	}

	/**
	 * Generate the MSRP price value for a product.
	 *
	 * @param  WC_Product  $wc_product
	 *
	 * @return string
	 */
	public static function get_msrp( WC_Product $wc_product ): string {
		if ( 'variation' === $wc_product->get_type() ) {
			$msrp_price = $wc_product->get_meta( '_msrp' );
		} else {
			$msrp_price = $wc_product->get_meta( '_msrp_price' );
		}
		if ( '' === $msrp_price ) {
			return '';
		}
		$price_string = number_format( (float) $msrp_price, 2, '.', '' );

		return $price_string . ' ' . get_woocommerce_currency();
	}
}
