<?php

declare( strict_types=1 );

$container = new \Ademti\WoocommerceMsrp\Dependencies\League\Container\Container();

// Admin.
$container->addShared( 'Admin', \Ademti\WoocommerceMsrp\Admin\Admin::class )
          ->addArguments( [ 'ImportExport', 'QuickEdit', 'ProductListColumn' ] );
$container->addShared( 'ImportExport', \Ademti\WoocommerceMsrp\Admin\ImportExport::class );
$container->addShared( 'QuickEdit', \Ademti\WoocommerceMsrp\Admin\QuickEdit::class );
$container->addShared( 'ProductListColumn', \Ademti\WoocommerceMsrp\Admin\ProductListColumn::class );

// Integrations.
$container->addShared( 'IntegrationManager', \Ademti\WoocommerceMsrp\Integrations\IntegrationManager::class )
          ->addArguments( [ $container ] );
$container->addShared( 'ProductAddons', \Ademti\WoocommerceMsrp\Integrations\ProductAddons::class );
$container->addShared( 'WoocommerceProductFeeds', \Ademti\WoocommerceMsrp\Integrations\WoocommerceProductFeeds::class );

// RestHandlers
$container->addShared( 'LegacyRestHandler', \Ademti\WoocommerceMsrp\RestHandlers\LegacyRestHandler::class );
$container->addShared( 'RestHandler', \Ademti\WoocommerceMsrp\RestHandlers\RestHandler::class );

// Top-level classes
$container->addShared( 'Frontend', \Ademti\WoocommerceMsrp\Frontend::class );
$container->addShared( 'Main', \Ademti\WoocommerceMsrp\Main::class )
          ->addArguments(
			  [
				  'Admin',
				  'Frontend',
				  'IntegrationManager',
				  'RestServiceManager',
				  'Shortcodes',
			  ]
          );
$container->addShared( 'RestServiceManager', \Ademti\WoocommerceMsrp\RestServiceManager::class )
          ->addArguments( [ $container ] );
$container->addShared( 'Shortcodes', \Ademti\WoocommerceMsrp\Shortcodes::class )
          ->addArguments( [ 'Frontend' ] );

// Class alias to support legacy settings of WoocommerceProductFeeds integration prepopulation option.
class_alias(
	\Ademti\WoocommerceMsrp\Integrations\WoocommerceProductFeeds::class,
	'woocommerce_msrp_woocommerce_product_feeds_integration'
);

return $container;
