<?php
/*
 * Plugin Name: WooCommerce MSRP Pricing
 * Plugin URI: https://woocommerce.com/products/msrp-pricing/
 * Description: A WooCommerce extension that lets you flag Manufacturer Suggested Retail Prices against products, and display them on the front end.
 * Author: Ademti Software Ltd.
 * Version: 4.1.0
 * Woo: 18727:b9133a56078a1ffa217e74136769022b
 * WC requires at least: 9.1
 * WC tested up to: 9.4
 * Author URI: https://www.ademti-software.co.uk/
 * License: GPLv3
*/

use Automattic\WooCommerce\Utilities\FeaturesUtil;

const WOOCOMMERCE_MSRP_VERSION = '4.1.0';

/**
 * Add default option settings on plugin activation
 */
function woocommerce_msrp_activate() {
	add_option( 'woocommerce_msrp_status', 'always', '', true );
	add_option( 'woocommerce_msrp_description', 'MSRP', '', true );
}
register_activation_hook( __FILE__, 'woocommerce_msrp_activate' );

/**
 * Require classes.
 */
require_once 'woocommerce-msrp-template-tags.php';
require __DIR__ . '/vendor/autoload.php';

global $woocommerce_msrp_container;
$woocommerce_msrp_container = require_once 'woocommerce-msrp-container.php';

// Run the extension when all plugins loaded.
add_action( 'plugins_loaded', [ $woocommerce_msrp_container->get( 'Main' ), 'run' ] );

// Set a global reference to the Frontend class to support legacy filter overrides.
global $woocommerce_msrp_frontend;
$woocommerce_msrp_frontend = $woocommerce_msrp_container->get( 'Frontend' );

/**
 * Declare support for High Performance Order Storage.
 */
add_action(
	'before_woocommerce_init',
	function () {
		if ( class_exists( FeaturesUtil::class ) ) {
			FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
		}
	}
);
