<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$options_handler = WCPP()->settings_handler;
$logo            = $options_handler->get_option( 'url_file' );
$active_fields   = $options_handler->get_option( 'active_fields' );

$render_info    = $options_handler->get_render_option_info();
$help_image_url = WCPP()->plugin_imgs_url() . '/help.png';

$sections = array(
	'company_info' => __( 'Company Info', 'woocommerce-pickingpal' ),
	'advanced'     => __( 'Advanced', 'woocommerce-pickingpal' ),
	'export'       => __( 'Export', 'woocommerce-pickingpal' ),
);
?>
<ul class="subsubsub">
	<?php foreach ( $sections as $id => $section_title ) : ?>
		<li>
			<a class="section_choice"
				data-section="<?php echo $id; ?>" href="#section=<?php echo $id; ?>">
					<?php echo $section_title; ?>
			</a>
			<?php echo( end( $sections ) == $section_title ? '' : ' | ' ); ?>
		</li>
	<?php endforeach; ?>
</ul><br class="clear"/>


<!--<input type="hidden" id="ovr_sku" value="--><?php // echo $WC_PickingPal->override_sku; ?><!--">-->
<form id="submit_form" class="pick-ticket-settings-form" method="post" action="">
	<?php foreach ( $sections as $index => $label ) : ?>
		<?php
		$class = array( 'section', $index . '-settings-section' );
		$id    = $index . '_section';
		?>
		<div class="section settings-section" id="<?php echo $id; ?>">
			<h2><?php echo $label; ?></h2>

			<table class="wp-picking-table-settings">
				<?php foreach ( $render_info[ $index ] as $option ) : ?>
					<?php include_once $option['view_path']; ?>
				<?php endforeach; ?>

			</table>
		</div>
	<?php endforeach; ?>

	<div class="pick-ticket-settings-submit-btn">
		<input type="submit" name="submit_form" class="button button-primary" id="pp-save-settings"
			value="<?php echo _e( 'Save changes', 'woocommerce-pickingpal' ); ?>">
	</div>
</form>
<div class="row clearfix2 wc-template" data-field="">
	<input type="hidden" name="" value="1">
	<div class="col1"></div>
</div>
