<?php
/**
 * Created by PhpStorm.
 * User: q
 * Date: 15.12.17
 * Time: 15:28
 */

class WCPP_Log_Tab extends WCPP_Tab {

	/**
	 * @var string Path to class views
	 */
	public $tab_name = 'log';

	public function thematic_enqueue_scripts() {
		parent::thematic_enqueue_scripts();

		if ( isset( $_REQUEST['activity_log'] ) ) {
			$tab_name         = $this->tab_name;
			$script_name      = 'ajax_script_' . $tab_name;
			$ajax_object_name = 'ajax_object_' . $tab_name . '_activity_log';

			wp_localize_script(
				$script_name,
				$ajax_object_name,
				array(
					'activity' => true,
					'order_id' => isset( $_REQUEST['order_log'] ) ? (int) ( $_REQUEST['order_log'] ) : null,
				)
			);
		}
	}

	public function print_log() {
		ini_set( 'memory_limit', '512M' );
		global $hook_suffix;
		$hook_suffix = 'woocommerce_page_PickingPal';
		include 'class-wcpp-list-log.php';
		$log = new WCPP_List_Log();
		echo $log->output_report();
		wp_die();
	}

	public function print_activity_log() {
		ini_set( 'memory_limit', '512M' );
		global $hook_suffix;
		$hook_suffix = 'woocommerce_page_PickingPal';
		include 'class-wcpp-list-activity-log.php';
		$log = new WCPP_List_Activity_Log( isset( $_REQUEST['order_id'] ) ? (int) ( $_REQUEST['order_id'] ) : null );
		echo $log->output_report();
		wp_die();
	}

	public function load_order_log() {
		global $wpdb;
		if ( isset( $_REQUEST['order_id'] ) ) {
			$postmeta_key_order_number = WCPP_Order_Extend::ORDER_META_ORDER_NUMBER;

			$order_id = @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $_REQUEST['order_id'] );

			$picker_data = new WCPP_Picker_Data( $order_id );
			$order_items = $picker_data->get_data();
			$order       = $order_items['order'];
			if ( WCPP()->is_hpos_enabled() ) {
				$order_number = $order->get_meta( $postmeta_key_order_number, true );
			} else {
				$order_number = get_post_meta( $order_id, $postmeta_key_order_number, true );
			}
			$pick_arr = $picker_data->get_pick_arr( $order_id );

			WCPP_Admin_Helper::wcpp_render_template(
				'order_log',
				array(
					'order_items'  => $order_items,
					'order_id'     => $order_id,
					'order_number' => $order_number,
					'pick_arr'     => $pick_arr,
				),
				WCPP_admin::admin_views_path()
			);
		}
	}
}
