<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$help_image_url             = isset( $help_image_url ) ? $help_image_url : null;
$warehouse_locations        = array();
$sort_by_warehouse_location = null;

if ( isset( $options_handler ) ) {
	$sort_by_warehouse_location  = $options_handler->get_option( 'sort_by_warehouse_location' );
	$fetched_warehouse_locations = $options_handler->get_option( 'warehouse_locations' );
	if ( is_array( $fetched_warehouse_locations ) ) {
		$warehouse_locations = $fetched_warehouse_locations;
	}
}
?>

<tr>
	<td>
		<?php _e( 'Warehouse Location', 'woocommerce-pickingpal' ); ?>
		<img class="help_tip" data-tip="" src="<?php echo $help_image_url; ?>"
			title="<?php echo _e( 'Warehouse Location', 'woocommerce-pickingpal' ); ?>" height="16"
			width="16">
	</td>
	<td>

		<input type="hidden" name="remove_warehouse_location_ids"/>
		<button class='button-primary' onclick="add_location(); return false;"
				style='float:right;margin-bottom: 5px;'>
				<?php
				_e(
					'Add Location',
					'woocommerce-pickingpal'
				)
				?>
				</button>
		<div style="clear:both"></div>

		<table class='simple-table-pp' id='locations'>
			<thead>
			<th><?php _e( 'Enabled', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( 'Label', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( '', 'woocommerce-pickingpal' ); ?></th>
			</thead>
			<tbody>
			<?php
			foreach ( $warehouse_locations as $key => $location ) {
				?>
				<tr>
					<td>
						<input type='hidden' name='location[<?php echo $key; ?>][enabled]' value="off"/>
						<input type="checkbox" <?php checked( $location['enabled'], 'on' ); ?>
								name='location[<?php echo $key; ?>][enabled]' value="on"/>
					</td>
					<td><input type='text' name='location[<?php echo $key; ?>][label]'
								value='<?php echo $location['label']; ?>'/></td>
					<td>
						<a onclick='remove_location(this, "<?php echo $key; ?>//"); return false;'>
							<span class="dashicons dashicons-trash"></span>
						</a>
					</td>
				</tr>
			<?php } ?>

			</tbody>
		</table>

		<tr class="table-td-align-top">
			<td><?php _e( 'Sort Pick Tickets/Lists & Pick windows by warehouse locations', 'woocommerce-pickingpal' ); ?>
			</td>
			<td>
				<span>
					<div class="switchbtn"></div>
					<input type="hidden" id="pickingpal-sort_by_warehouse_location"
							value="<?php echo $sort_by_warehouse_location; ?>"
							name="pickingpal-sort_by_warehouse_location" class="switchbtn_value">
				</span>
			</td>
		</tr>

	</td>
</tr>
