<?php
/**
 * @deprecated Use template_print_packing_slip.php instead
 *
 * //PRINT PACKING SLIP
 *
 * @var array $orders
 * @var string $url_list_css
 * @var array $order_items
 * @var array $pick_arr
 * @var bool $with_additional_skus
 * @var bool $with_warehouses
 * @var bool $with_product_images
 * @var bool $with_customer_notes
 */


?>
<link rel="stylesheet" type="text/css" href="<?php echo $url_list_css; ?>">

<div class="page">

	<?php
	foreach ( $orders as $order ) {
		$order_number   = ltrim( $order->get_order_number(), '#' );
		$billing_phone  = $order->get_billing_phone();
		$shipping_phone = $order->get_shipping_phone();
		?>
		<div>
			<?php
			// $img = get_option('pickingpal-logo');
			$img = WCPP()->settings_handler->get_option( 'url_file' );
			if ( $img ) {
				?>
				<img src="<?php echo $img; ?>" class="logo">
				<?php
			}
			?>
		</div>
		<div class="info">
<!--            --><?php // echo nl2br( get_option( 'pickingpal-contact' ) ); ?>
			<?php echo nl2br( WCPP()->settings_handler->get_option( 'contact' ) ); ?>
		</div>
		<div class="clearfix"></div>
		<div class="border-x"></div>


		<div class="header">
			<div class="header-left">
				<table>
					<tr>
						<td>
							<h3><?php echo __( 'Billing Address', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2">
								<?php echo $order->get_formatted_billing_address(); ?>
								<?php echo $billing_phone ? '<br/>Phone: ' . $billing_phone : null; ?>
							</div>
						</td>
						<td>
							<h3><?php echo __( 'Shipping Address', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2">
								<?php echo $order->get_formatted_shipping_address(); ?>
								<?php echo $shipping_phone ? '<br/>Phone: ' . $shipping_phone : null; ?>
							</div>
						</td>
						<td>
							<h3><?php echo __( 'Shipping method', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2">
								<?php echo $order->get_shipping_method(); ?>
							</div>
						</td>
					</tr>
				</table>

				<h3 style="clear: both;">
				<?php
					echo __( 'Ship Date: ', 'woocommerce-pickingpal' );
					echo current_time( 'm-d-Y' );
				?>
					&nbsp;&nbsp;&nbsp;
					<?php
						echo __( 'Order Date: ', 'woocommerce-pickingpal' );
						$order_date_timestamp = is_string( $order->get_date_created() ) ? strtotime( $order->get_date_created() ) : $order->get_date_created()->getOffsetTimestamp();
						echo date( 'm-d-Y', $order_date_timestamp );
					?>
				</h3>

				<?php if ( $with_customer_notes ) : ?>
					<h3>
						<?php
						$customer_notes = $order->get_customer_note() ? $order->get_customer_note() : '---';
						printf( '%s : %s', __( 'Customer notes', 'woocommerce-pickingpal' ), $customer_notes );
						?>
					</h3>
				<?php endif; ?>
			</div>
			<div class="header-right">
				<div class="barcode">
					<div><?php echo __( 'Invoice', 'woocommerce-pickingpal' ); ?> #<?php echo $order_number; ?></div>
					<font face="IDAutomationHC39M">(<?php echo $order_number; ?>)</font>
				</div>

<!--				<div class="picktiket-heading">--><?php // echo get_option( 'pickingpal-picktiket_heading' ); ?><!--</div>-->
				<div class="picktiket-heading"><?php echo WCPP()->settings_handler->get_option( 'picktiket_heading' ); ?></div>
			</div>
		</div>

		<table class="products-list" style="">
			<tr class="item-line">
				<?php if ( $with_product_images ) : ?>
					<th class="header-list"><?php echo __( 'Product Image', 'woocommerce-pickingpal' ); ?></th>
				<?php endif; ?>
				<th class="header-list"><?php echo __( 'Product Name', 'woocommerce-pickingpal' ); ?></th>
				<?php if ( $with_additional_skus ) : ?>
					<th class="header-list"><?php echo __( 'Additional SKUs', 'woocommerce-pickingpal' ); ?></th>
				<?php endif; ?>
				<?php if ( $with_warehouses ) : ?>
					<th class="header-list"><?php echo __( 'Warehouse Locations', 'woocommerce-pickingpal' ); ?></th>
				<?php endif; ?>
				<th class="header-list"><?php echo __( 'Qty Ordered', 'woocommerce-pickingpal' ); ?></th>
				<th class="header-list"><?php echo __( 'Qty Shipped', 'woocommerce-pickingpal' ); ?></th>
				<!--<th class="header-list"><?php echo __( 'Qty Override', 'woocommerce-pickingpal' ); ?></th>-->
				<th class="header-list"><?php echo __( 'Qty Backordered', 'woocommerce-pickingpal' ); ?></th>
				<th class="header-list"><?php echo __( 'Qty Restocked', 'woocommerce-pickingpal' ); ?></th>
			</tr>
			<?php
			foreach ( $order_items['products'] as $key => $value ) {
				if ( ! isset( $value['name'] ) or ! isset( $value['name'] ) ) {
					continue;
				}
				$name           = $value['name'];
				$qty            = $value['qty'];
				$qty_required   = $value['qty_required'];
				$qty_overpicked = $value['qty_overpicked'];
				$qty_restocked  = $value['qty_restocked'];
				if ( isset( $value['isparent'] ) and $value['isparent'] == 1 ) {
					$parent_qty = $value['qty'];
				}
				$bundle_class = isset( $value['bundle_qty'] ) ? 'bundle-element' : '';
				$qtyOvr       = $qty_overpicked ? 'Y' : 'N';
				$qtyPck       = (int) $value['qty_picked'];

				if ( isset( $value['backordered'] ) ) {
					$qtyBack = $value['backordered'];
				} else {
					$qtyBack = 0;
				}

				?>
				<tr class="item-line">
					<?php if ( $with_product_images ) : ?>
						<td><?php echo isset( $value['image'] ) ? $value['image'] : ''; ?></td>
					<?php endif; ?>
					<td>
						<div class="<?php echo $bundle_class; ?>"><?php echo $name; ?></div>
					</td>
					<?php if ( $with_additional_skus ) : ?>
						<td><?php echo $value['additional_skus']; ?></td>
					<?php endif; ?>
					<?php if ( $with_warehouses ) : ?>
						<td><?php echo $value['warehouse']; ?></td>
					<?php endif; ?>
					<td>
						<?php echo $qty; ?>
					</td>
					<td>
						<?php echo $qtyPck; ?>
					</td>
					<!--
					<td>
						<?php echo $qtyOvr; ?>
					</td>
					-->
					<td>
						<?php echo $qtyBack; ?>
					</td>
					<td>
						<?php echo $qty_restocked; ?>
					</td>
				</tr>
				<?php
			}
			?>
		</table>
		<p></p>
		<h3><?php echo __( 'Comments', 'woocommerce-pickingpal' ); ?>:</h3>
		<div class="comments">
			<?php echo __( 'If shown, backordered items will ship as they become available.', 'woocommerce-pickingpal' ); ?>

		</div>
		<?php
	}
	?>

</div>
<script>
	if(document.images.length){ //wait for images to load
		Promise.all(Array.from(document.images).filter(img => !img.complete).map(img => new Promise(resolve => { img.onload = img.onerror = resolve; }))).then(() => {
			window.print();
		});
	} else {
		window.print();
	}
</script>
