<?php
/**
 *  PICK LIST PRINT TEMPLATE
 *
 * @var WCPP_Print_Template_Data             $data
 *
 *   This template presents a list of items to pick from a collection of orders.
 *   The items are grouped by product and sorted by warehouse location.
 *
 *   The $data object available in this template provides methods to access data.
 *   This template uses the following data properties:
 *
 * @property-read string                     $url_template_css    Url of the template CSS file
 * @property-read string                     $logo                Url of the logo image
 * @property-read string                     $contact_info        Contact information of the company
 * @property-read string                     $heading             Heading text for the print
 * @property-read string                     $date_generated      The date when the print is generated
 * @property-read string                     $show_customer_notes A flag indicating whether to show customer notes
 * @property-read string                     $show_product_images A flag indicating whether to show product images
 * @property-read string                     $show_warehouse_locations A flag indicating whether to show warehouse locations column
 * @property-read int                        $combined_items_qty_required The total number of units required.
 * @property-read WCPP_Print_Template_Data[] $combined_items_data An array containing template data for the items to pick.
 *   This is an array of WCPP_Print_Template_Data objects.
 *
 *   To access these properties use the methods ->get_var() and to output these properties use ->print_var()
 *   Eg `<?php $data->print_var('contact_info'); ?>`
 *
 *   To list property keys available for a WCPP_Print_Template_Data data object use ->list_properties();
 *   Eg `<?php print_r($data->get_var('combined_items_data')[0]->list_properties()); ?>
 * /
 */
$data    = isset( $data ) ? $data : new WCPP_Print_Template_Data( array() );
$colspan = 5;
if ( ! $data->get_var( 'show_product_images' ) ) {
	--$colspan;
}
if ( ! $data->get_var( 'show_warehouse_locations' ) ) {
	--$colspan;
}
?>

<link rel="stylesheet" type="text/css" href="<?php echo $data->get_var( 'url_template_css' ); ?>">

<div class="template template--pick-list">

	<div class="header">

		<div class="header__company-info">
			<img src="<?php echo $data->get_var( 'logo' ); ?>" class="header__logo">
			<?php $data->print_var( 'contact_info' ); ?>
		</div>

		<div class="header__title">
			<h1>
				<?php $data->print_var( 'heading' ); ?>
			</h1>
			<small>
				<?php echo __( 'Generated' ); ?>: <?php $data->print_var( 'date_generated' ); ?>
			</small> <br/>
		</div>

	</div>

	<div class="content">
		<h3><?php printf( __( 'Total Items Required: %d', 'woocommerce-pickingpal' ), $data->get_var( 'combined_items_qty_required' ) ); ?></h3>

		<table class="order__items">
			<thead>
			<tr>
				<?php if ( $data->get_var( 'show_product_images' ) ) : ?>
					<th><?php echo __( 'Image', 'woocommerce-pickingpal' ); ?></th>
				<?php endif; ?>
				<th><?php echo __( 'Item', 'woocommerce-pickingpal' ); ?></th>
				<?php if ( $data->get_var( 'show_warehouse_locations' ) ) : ?>
					<th><?php echo __( 'Location', 'woocommerce-pickingpal' ); ?></th>
				<?php endif; ?>
				<th># <?php echo __( 'Required', 'woocommerce-pickingpal' ); ?></th>
				<th># <?php echo __( 'Restocked', 'woocommerce-pickingpal' ); ?></th>
			</tr>
			</thead>
			<tbody>
			<?php if ( $data->get_var( 'combined_items_data' ) ) : ?>

				<?php foreach ( $data->get_var( 'combined_items_data' ) as $item_data ) : ?>
					<tr class="order__item">

						<?php if ( $data->get_var( 'show_product_images' ) ) : ?>
							<td class="info info--image">
								<?php $item_data->print_var( 'image' ); ?>
							</td>
						<?php endif; ?>

						<td class="info info--description">
							<b><?php $item_data->print_var( 'name' ); ?></b>
							<?php echo $item_data->get_var( 'description' ) ? '<br/>' : null; ?>
							<?php $item_data->print_var( 'description' ); ?>
							<?php if ( $item_data->get_var( 'additional_skus' ) ) : ?>
								<?php foreach ( $item_data->get_var( 'additional_skus' ) as $sku_key => $sku_data ) : ?>
									<?php echo '<br/>' . $sku_data['label'] . ': ' . $sku_data['value']; ?>
								<?php endforeach; ?>
							<?php endif; ?>
						</td>

						<?php if ( $data->get_var( 'show_warehouse_locations' ) ) : ?>
							<td class="info info--locations">
								<?php $item_data->print_var( 'warehouses' ); ?>
							</td>
						<?php endif; ?>

						<td class="info info--quantity">
							<?php $item_data->print_var( 'qty_required' ); ?>
						</td>

						<td class="info info--quantity">
							<?php wc_price( $item_data->print_var( 'qty_restocked' ) ); ?>
						</td>

					</tr>
					<?php do_action( 'wcpp_after_pick_list_row', $item_data, count( $data->get_var( 'orders_data' ) ) ); ?>
				<?php endforeach; ?>
			<?php else : ?>
				<tr class="order__item">
					<td class="info info--image" colspan="<?php echo $colspan; ?>" style="text-align: center;">
						<?php echo __( 'There are no items available for picking', 'woocommerce-pickingpal' ); ?>.
					</td>
				</tr>
			<?php endif; ?>
			</tbody>
		</table>


	</div>

</div>
