<?php

/**
 * PACKING SLIP PRINT TEMPLATE
 *
 * @var WCPP_Print_Template_Data             $data
 *
 *  This template provides a slip that can be included when packing goods for an order.
 *
 *
 *  The $data object available in this template provides methods to access data.
 *  This template uses the following data properties:
 *
 * @property-read string                     $url_template_css    Url of the template CSS file
 * @property-read string                     $logo                Url of the logo image
 * @property-read string                     $contact_info        Contact information of the company
 * @property-read string                     $heading             Heading text for the print
 * @property-read string                     $date_generated      The date when the print is generated
 * @property-read string                     $show_customer_notes A flag indicating whether to show customer notes
 * @property-read string                     $show_product_images A flag indicating whether to show product images
 * @property-read string $show_warehouse_locations A flag indicating whether to show warehouse locations column
 * @property-read WCPP_Print_Template_Data[] $orders_data         An array containing template data for the orders associated with this order.
 *
 * This is an array of WCPP_Print_Template_Data objects.
 *
 *  To access these properties use the methods ->get_var() and to output these properties use ->print_var()
 *  Eg `<?php $data->print_var('contact_info'); ?>`
 *
 *  To list property keys available for a WCPP_Print_Template_Data data object use ->list_properties();
 *  Eg `<?php print_r($data->get_var('orders_data')[0]->list_properties()); ?>
 */
$data      = isset( $data ) ? $data : new WCPP_Print_Template_Data( array() );
$pageCount = 0;
$colspan   = 4;
if ( ! $data->get_var( 'show_product_images' ) ) {
	--$colspan;
}
if ( ! $data->get_var( 'show_warehouse_locations' ) ) {
	--$colspan;
}
?>
<link rel="stylesheet" type="text/css" href="<?php echo $data->get_var( 'url_template_css' ); ?>">

<div class="template template--pick-ticket">

	<?php
	if ( $data->get_var( 'orders_data' ) ) :
		++$pageCount;
		?>
		<?php foreach ( $data->get_var( 'orders_data' ) as $order_data ) : ?>
			<div class="page<?php echo $pageCount === 1 ? '--first' : null; ?>">
				<div class="header">

					<div class="header__company-info">
						<img src="<?php echo $data->get_var( 'logo' ); ?>" class="header__logo">
						<?php $data->print_var( 'contact_info' ); ?>
					</div>

					<div class="header__title">
						<h1>
							<?php $data->print_var( 'heading' ); ?>
						</h1>
						<small>
							<?php echo __( 'Generated' ); ?>: <?php $data->print_var( 'date_generated' ); ?>
						</small> <br/>
					</div>

				</div>

				<div class="content">
					<div class="order">

						<div class="order__header">
							<div class="info info--order">
								<h2>
									<?php echo __( 'Order', 'woocommerce-pickingpal' ); ?> <?php $order_data->print_var( 'order_number' ); ?>
									<br/>
									<small>
										<?php $order_data->print_var( 'order_date_formatted' ); ?>
									</small>
								</h2>
								<?php if ( $data->get_var( 'show_customer_notes' ) ) : ?>
									<h3>
										<?php echo __( 'Customer notes', 'woocommerce-pickingpal' ); ?>: <?php $order_data->print_var( 'customer_notes' ); ?>
									</h3>
								<?php endif; ?>
							</div>
							<div class="order__barcode">
								<?php $order_data->print_var( 'barcode_id' ); ?>
							</div>
						</div>

						<div class="order__info">
							<div class="info info--billing">
								<h3><?php echo __( 'Billing Address', 'woocommerce-pickingpal' ); ?></h3>
								<small>
									<?php $order_data->print_var( 'billing_address' ); ?>
									<br><?php echo __( 'Phone', 'woocommerce-pickingpal' ); ?>: <?php $order_data->print_var( 'billing_phone' ); ?>
								</small>
							</div>

							<div class="info info--shipping">
								<h3><?php echo __( 'Shipping Address', 'woocommerce-pickingpal' ); ?></h3>
								<small>
									<?php $order_data->print_var( 'shipping_address' ); ?>
									<br><?php echo __( 'Phone', 'woocommerce-pickingpal' ); ?>: <?php $order_data->print_var( 'shipping_phone' ); ?>
								</small>
							</div>

							<div class="info info--value">
								<h3><?php echo __( 'Shipping Info', 'woocommerce-pickingpal' ); ?></h3>
								<small>
									<?php $order_data->print_var( 'shipping_method' ); ?><br/>
									<?php $order_data->print_var( 'shipping_value' ); ?> (+ <?php $order_data->print_var( 'shipping_tax' ); ?> TAX)
								</small>
							</div>
						</div>


						<table class="order__items">
							<thead>
							<tr>
								<?php if ( $data->get_var( 'show_product_images' ) ) : ?>
									<th><?php echo __( 'Image', 'woocommerce-pickingpal' ); ?></th>
								<?php endif; ?>
								<th><?php echo __( 'Item', 'woocommerce-pickingpal' ); ?></th>
								<?php if ( $data->get_var( 'show_warehouse_locations' ) ) : ?>
									<th><?php echo __( 'Location', 'woocommerce-pickingpal' ); ?></th>
								<?php endif; ?>
								<th># <?php echo __( 'Unpicked', 'woocommerce-pickingpal' ); ?></th>
							</tr>
							</thead>
							<tbody>
							<?php if ( $order_data->get_var( 'items_data' ) ) : ?>
								<?php foreach ( $order_data->get_var( 'items_data' ) as $item_data ) : ?>
									<tr class="order__item">

										<?php if ( $data->get_var( 'show_product_images' ) ) : ?>
											<td class="info info--image">
												<?php $item_data->print_var( 'image' ); ?>
											</td>
										<?php endif; ?>

										<td class="info info--description">
											<b><?php $item_data->print_var( 'name' ); ?></b>
											<?php echo $item_data->get_var( 'description' ) ? '<br/>' : null; ?>
											<?php $item_data->print_var( 'description' ); ?>
											<?php if ( $item_data->get_var( 'additional_skus' ) ) : ?>
												<?php foreach ( $item_data->get_var( 'additional_skus' ) as $sku_key => $sku_data ) : ?>
													<?php echo '<br/>' . $sku_data['label'] . ': ' . $sku_data['value']; ?>
												<?php endforeach; ?>
											<?php endif; ?>

										</td>

										<?php if ( $data->get_var( 'show_warehouse_locations' ) ) : ?>
											<td class="info info--locations">
												<?php $item_data->print_var( 'warehouses' ); ?>
											</td>
										<?php endif; ?>

										<td class="info info--quantity">
											<?php echo max( 0, $item_data->get_var( 'qty_required' ) - $item_data->get_var( 'qty_picked' ) ); ?>
										</td>

									</tr>
								<?php endforeach; ?>
							<?php else : ?>
								<tr class="order__item">
									<td class="info info--image" colspan="<?php echo $colspan; ?>" style="text-align: center;">
										<?php echo __( 'This order does not have any items available for picking', 'woocommerce-pickingpal' ); ?>.
									</td>
								</tr>
							<?php endif; ?>
							</tbody>
						</table>

						<?php if ( $order_data->get_var( 'backordered_items_data' ) ) : ?>
							<h4> <?php echo __( 'The following items are on backorder', 'woocommerce-pickingpal' ); ?>.</h4>
							<ul>
								<?php foreach ( $order_data->get_var( 'backordered_items_data' ) as $item_data ) : ?>
									<li><?php $item_data->print_var( 'backordered' ); ?> x <?php $item_data->print_var( 'name' ); ?></li>
								<?php endforeach; ?>
							</ul>
							<p>* <?php echo _e( 'Backorder items will ship as they become available', 'woocommerce-pickingpal' ); ?></p>
						<?php endif; ?>

					</div>


				</div>
			</div>

		<?php endforeach; ?>
	<?php endif; ?>

</div>
