(function ($) {

	$.extend({
		playSound: function () {
			return $("<audio autoplay='autoplay' style='display:none;' controls='controls'><source src='" + arguments[0] + ".mp3' /><source src='" + arguments[0] + ".ogg' /></audio>").appendTo('body');
		}
	});

	const Order = function (postData) {
		let orderData = postData.order_items.order;
		let productData = postData.order_items.products;
		let orderPicked = postData.order_items.picked;
		let processing = postData.order_items.processing;

		return {
			getId    : function () {
				return orderData.hasOwnProperty('order_id') ? orderData.order_id : orderData.post.ID;
			},
			getNumber : function(){
				return orderData.hasOwnProperty('order_number') ? orderData.order_number : orderData.post.ID;
			},
			getStatus: function () {
				return orderData.hasOwnProperty('post_status') ? orderData.post_status : null;
			},
			getCustomerNote : function(){
				return orderData.hasOwnProperty('customer_note') ? orderData.customer_note : null;
			},
			isPicked : function () {
				return orderPicked ? true : false;
			},
			getItems : function () {
				let items = [];
				$.each(productData, function (index, itemData) {
					itemData.index = index;
					let item = new Item(itemData);
					if(item && item.getProperty('name')) { //you gotta have a product name
						items.push(item);
					}
				})
				return items;
			},
			setStatus: function (statusName) {
				orderData.post_status = statusName;
			},
			setPickingEnabled : function(bool){
				orderData.picking_enabled = !!bool;
			},
			isPickingEnabled : function(){
				if(orderData.hasOwnProperty('picking_enabled')){
					return orderData.picking_enabled;
				}
				return !!this.getId();
			}
		}
	};

	const Item = function (itemPostData) {
		let data = itemPostData;
		return {
			getSKU        : function () {
				return this.getProperty('sku');
			},
			getLookupCodes: function () {
				let codes = [];
				codes.push(this.getSKU());
				let additionalCodes = this.getProperty('additional_skus');
				if (additionalCodes) {
					if (typeof additionalCodes === 'object') {
						additionalCodes = Object.values(additionalCodes);
					}
					$.each(additionalCodes, function (index, code) {
						if (typeof code === 'object' && code.value) {
							code = code.value;
						}
						codes.push(code);
					});
				}
				return codes;
			},
			getId         : function () {
				return this.getProperty('index');
			},
			getQuantity   : function () { //the quantity ordered
				let qty = this.getProperty('qty');
				if (qty) {
					return parseInt(qty);
				}
				return 0;
			},
			getQuantityRequired : function() { //the quantity ordered after refunds/restocked
				let qty = this.getProperty('qty_required');
				if (qty) {
					return parseInt(qty);
				}
				return 0;
			},
			getQuantityAvailable : function(){ //the quantity available to pick
				return this.getQuantityRequired() - this.getQuantityBackordered();
			},
			getQuantityBackordered : function(){
				let qty = this.getQuantityRequired();
				if(!qty){
					return 0;
				}
				let backordered = this.getProperty('backordered');
				if (backordered) {
					backordered = parseInt(backordered);
					return Math.min(qty, backordered);
				}
				return 0;
			},
			getProperty   : function (propertyName) {
				return data.hasOwnProperty(propertyName) ? data[propertyName] : null;
			},
			isBundleItem : function(){
				if(this.getParentId() >= 0){
					return true;
				}
				return false;
			},
			isBundle : function(){
				if(this.getProperty('isparent') == 1){
					return true;
				}
				return false;
			},
			getBundleItemQuantity : function(){
				let qty = this.getProperty('bundle_qty');
				if (qty) {
					return parseInt(qty);
				}
				return 0;
			},
			getParentId : function(){
				return this.getProperty('parent');
			},
			getData       : function () {
				return Helpers.cloneObj(data);
			}
		}
	};

	const Helpers = {
		isEnterKey: function (event) { //getCharCode
			let code = (event.which) ? event.which : event.keyCode;
			if (code == 13) {
				return true;
			}
			return false;
		},
		cloneObj  : function (obj) {
			if (null == obj || "object" != typeof obj)
				return obj;
			let copy = obj.constructor();
			for (let attr in obj) {
				if (obj.hasOwnProperty(attr))
					copy[attr] = obj[attr];
			}
			return copy;
		},
		callback  : function () {
			this.add = function (callback, extparams) {
				if (typeof (this.callbacks) == 'undefined') {
					this.callbacks = [];
				}
				this.callbacks[this.callbacks.length] = {callback: callback, extparams: extparams};
			}
			this.run = function (params) {
				if (typeof (params) == 'undefined') {
					params = {};
				}
				if (typeof (this.callbacks) != 'undefined') {

					jQuery.each(this.callbacks, function (index, e) {

						e.callback(params, e.extparams)
					})
				}
			}
		},
		isProVersion : function(){
			if (typeof PickingPalPro !== 'undefined') {
				return true;
			}
			return false;
		}
	};

	const Scanner = {
		productInputId    : '#pickingpal-input--product-sku',
		orderInputNumber      : '#pickingpal-input--order-number',
		events            : {
			scan_product: new Helpers.callback(),
			scan_order  : new Helpers.callback(),
		},
		focusInput        : function (elId, clearInput) {
			let $inputEl = $(elId);
			if ($inputEl.length) {
				if (clearInput) {
					$inputEl.val(null);
				}
				$inputEl.focus();
				$inputEl.select();
			}
		},
		focusProductInput : function(clearInput){
			clearInput = !!clearInput;
			this.focusInput(this.productInputId, clearInput);
		},
		focusOrderInput : function(clearInput){
			clearInput = !!clearInput;
			this.focusInput(this.orderInputNumber, clearInput);
		},
		triggerOrderScan  : function (inputValue) {
			if (inputValue === undefined) {
				let elId = this.orderInputNumber;
				inputValue = $(elId).val();
			}
			inputValue = inputValue.trim();
			if (inputValue.length > 0) {
				this.events.scan_order.run({
					value: inputValue,
				});
				this.ready();
			}
		},
		triggerProductScan: function (inputValue) {
			if (inputValue === undefined) {
				let elId = this.productInputId;
				inputValue = $(elId).val();
			}
			inputValue = inputValue.trim();
			if (inputValue.length > 0) {
				this.events.scan_product.run({
					value: inputValue,
				});
				this.ready();
			}
		},
		ready             : function () {
			if (Picker.getOrderId() && !Picker.isPickingComplete()) {
				this.focusProductInput(true);
			} else {
				this.focusProductInput(true);
				this.focusOrderInput(false);
			}
		},
		init              : function () {
			let _this = this;
			let $container = $('body');

			//Order Code Input
			$container.on('keypress', this.orderInputNumber, function (ev) {
				if (Helpers.isEnterKey(ev)) {
					_this.triggerOrderScan($(this).val());
				}
			});

			//Product Code Input
			$container.on('keypress', this.productInputId, function (ev) {
				if (Helpers.isEnterKey(ev)) {
					_this.triggerProductScan($(this).val());
				}
			});

			this.ready();
		}
	};

	const Sounds = {
		itemError        : function () {
			let el = document.getElementById("audio_item_error");
			if (el !== null) {
				this.playAudioElement(el);
			}
		},
		orderLoad        : function () {
			let el = document.getElementById("audio_order_load");
			if (el !== null) {
				this.playAudioElement(el);
			}
		},
		itemSuccess      : function () {
			let el = document.getElementById("audio_item_success");
			if (el !== null) {
				this.playAudioElement(el);
			}
		},
		orderComplete    : function () {
			let el = document.getElementById("audio_order_complete");
			if (el !== null) {
				this.playAudioElement(el);
			}
		},
		orderStatusChange: function () {
			let el = document.getElementById("change_order_status");
			if (el !== null) {
				this.playAudioElement(el);
			}
		},
		playAudioElement : function (el) { //playSound
			el.pause();
			el.currentTime = 0;
			setTimeout(function () {
				el.play();
			}, 150);
		}
	}

	const Ui = {
		$container    : null,
		$progressBar  : null,
		$progressLabel: null,

		resetProgressBar     : function () {
			this.setProgressBarValue(null);
			this.$progressLabel.text(' ');
		},
		setProgressBarValue  : function (value) {
			this.$progressBar.progressbar("value", value);
		},
		showOrderButtons     : function () {
			$('#pickingpal-order-buttons').show();
		},
		hideOrderButtons     : function () {
			$('#pickingpal-order-buttons').hide();
		},
		showPickerResetButton: function () {
			let $el = $('#pickingpal-btn--reset-picking-status');
			if ($el.length) {
				$el.removeClass('loading');
				$el.show();
			}
		},
		hidePickerResetButton: function () {
			let $el = $('#pickingpal-btn--reset-picking-status');
			if ($el.length) {
				$el.removeClass('loading');
				$el.hide();
			}
		},
		clearStatusBar       : function () {
			let target = $('#pickingpal-status-x');
			let style_target = $('#pickingpal-status-x__wrap');
			style_target.removeClass();
			target.html('');
			let $statusEl = $('#pickingpal-order-status');
			$statusEl.html('');
			$statusEl.hide();
		},
		displayOrderStatus   : function (statusName) {
			let $statusEl = $('#pickingpal-order-status');
			if ($statusEl.length) {
				$statusEl.html('');
				$statusEl.hide();
				$('#pickingpal-status-x-delimiter').hide();
				if(!statusName){
					let order = Picker.getOrder();
					if (order) {
						statusName = order.getStatus();
					}
				}
				if (statusName) {
					$statusEl.html(statusName);
					$statusEl.show();
					$('#pickingpal-status-x-delimiter').show();
				}
			}
		},
		displayCustomerNote : function(){
			let order = Picker.getOrder();
			if(order) {
				$el = $('#pickingpal-field--customer-notes');
				if ($el.length) {
					$el.val(order.getCustomerNote());
				}
			}
		},
		alertStatus          : function (status, options) {
			let target = $('#pickingpal-status-x');
			let style_target = $('#pickingpal-status-x__wrap');
			style_target.removeClass();
			switch (status) {
				case 'order_loaded':
					target.html(text['Order Loaded']);
					style_target.addClass('order-loaded');
					Sounds.orderLoad();
					break;
				case 'order_not_found':
					target.html(text['Order Not Found']);
					style_target.addClass('order-not-found');
					Sounds.itemError();
					break;
				case 'not_valid_order_status':
					target.html(options.message);
					style_target.addClass('order-not-found');
					Sounds.itemError()
					break;
				case 'scan_order':
					target.html(text['Scan Order']);
					style_target.addClass('scan-order');
					break;
				case 'order_picked':
					target.html(text['Order Loaded (PICKED)']);
					style_target.addClass('order-picked');
					Sounds.orderComplete();
					break;
				case 'not_found':
					target.html(text['product not found']);
					style_target.addClass('not-found');
					Sounds.itemError();
					break;
				case 'found':
					target.html(text['product found']);
					style_target.addClass('found');
					Sounds.itemSuccess();
					break;
				case 'order_status_changed_to':
					target.html(text['order_status_changed']);
					style_target.addClass('found');
					Sounds.orderStatusChange();
					break;
				case 'order_status_change_failed':
					target.html(text['order_status_change_failed']);
					style_target.addClass('order-not-found');
					Sounds.itemError();
					break;
				case 'loading':
					target.html(text['loading']);
					style_target.addClass('loading');
					break;
				default :
					target.html(status);
					style_target.addClass(status);
					break;
			}
		},
		emptyLists           : function () {
			this.updateItemList('picked', []);
			this.updateItemList('back-picked', []);
			this.updateItemList('unpicked', []);
			this.updateItemList('back-unpicked', []);
		},
		updateItemLists      : function () {
			let unpickedItems = Picker.getUnpickedItems();
			let pickedItems = Picker.getPickedItems();
			this.updateItemList('picked', pickedItems);
			this.updateItemList('back-picked', pickedItems, true);
			this.updateItemList('unpicked', unpickedItems);
			this.updateItemList('back-unpicked', unpickedItems, true);
		},
		updateItemList(listName, items, backordered) {
			let pickedContext = ['picked', 'back-picked'].includes(listName);
			let backorderedContext = backordered ? true : false;
			let quantityContext = backorderedContext ? 'backordered' : 'available';
			let _this = this;
			let $listContainer = $('#pickingpal-itemslist--' + listName);
			$listContainer.html('');

			//Add Items
			$.each(items, function (index, item) {
				let itemIsBundle = item.isBundle();
				let quantityToDisplay = pickedContext ? Picker.getItemPickedQuantity(item, quantityContext) : Picker.getItemQuantityToPick(item, quantityContext);
				if(quantityToDisplay > 0) {
					let itemClass = itemIsBundle ? 'parent_item' : 'item';
					let $itemContainer = $listContainer.find('.'+itemClass+'[data-index=' + item.getId() + ']');
					if(!$itemContainer.length){
						$itemContainer = $('<div class="' + itemClass + '" data-index="' + item.getId() + '"></div>');
					}
					$itemContainer.html(_this.makeItemHtml(item, quantityToDisplay));
					$listContainer.append($itemContainer);
				}
			})

			//Move bundle items into bundle item containers
			$.each(items, function (index, item) {
				if (item.isBundleItem()) { //add the item to bundle container
					let quantityToDisplay = pickedContext ? Picker.getItemPickedQuantity(item, quantityContext) : Picker.getItemQuantityToPick(item, quantityContext);
					if(quantityToDisplay > 0) {
						let $itemEl = $listContainer.find('.item[data-index=' + item.getId() + ']');
						let $parentItemEl = $listContainer.find('.parent_item[data-index=' + item.getParentId() + ']');
						if (!$parentItemEl.length) {
							//create a bundle container
							let parentItem = Picker.findItemById(item.getParentId());
							if (parentItem) {
								$parentItemEl = $('<div class="parent_item" data-index="' + item.getParentId() + '"></div>');
								$parentItemEl.html(_this.makeItemHtml(parentItem, 0));
								$listContainer.append($parentItemEl);
							}
						}

						if ($parentItemEl.length && $itemEl.length) {
							//move the item to the bundle container
							$parentItemEl.append($itemEl);
						}
					}
				}
			});

		},
		makeItemHtml: function (item, quantityToDisplay) {
			let html = ['<div class="item-name">'];

			if (item.getProperty('image')) {
				if (item.getProperty('image_url')) {
					html.push('<a class="product-img thickbox" href="');
					html.push(item.getProperty('image_url'));
					html.push('?TB_iframe=true&width=1024&height=600">');
					html.push(item.getProperty('image'));
					html.push('</a>');
				} else {
					html.push('<span class="product-img">');
					html.push(item.getProperty('image'));
					html.push('</span>');
				}
			}

			html.push('<span class="item-info">');

			if (item.getProperty('image_url')) {
				html.push('<a href="');
				html.push(item.getProperty('image_url'));
				html.push('?TB_iframe=true&width=1024&height=600" class="thickbox">');
				html.push('</a>');
				html.push(item.getProperty('name'));
			} else {
				html.push(item.getProperty('name'));
			}

			if (item.getProperty('is_digital') && (item.getSKU() || item.getProperty('additional_skus').length > 0)) {
				html.push('<span class="pick_item" data-itemid="'+item.getId()+'">' + ' | ' + '<a href="#">' + text.pick + '</a>' + '</span>');
			}

			if (!!item.getProperty('additional_sku_labels') || !!item.getProperty('warehouse')) {
				html.push('<br>');
			}

			if (item.getProperty('additional_sku_labels')) {
				html.push(item.getProperty('additional_sku_labels'));
			}

			if (item.getProperty('warehouse')) {
				if (item.getProperty('additional_sku_labels')) {
					html.push('<span> | </span>');
				}
				html.push(item.getProperty('warehouse'));
			}

			html.push('</span></div>');

			html.push('<div class="item-quantity">');
			html.push(quantityToDisplay);
			html.push('</div>');

			return html.join('');
		},
		reset       : function () {
			this.emptyLists();
			this.displayCustomerNote();
			this.displayOrderStatus();
			this.clearStatusBar();
			this.resetProgressBar();
			this.hideOrderButtons();
			this.hidePickerResetButton();
			Scanner.focusOrderInput(false);
		},
		update      : function () {
			if (!Picker.getOrder()) {
				this.reset();
				return;
			}
			this.displayCustomerNote();
			this.updateItemLists();
			this.setProgressBarValue(Picker.getProgressPercentage());
			this.displayOrderStatus();
			this.showOrderButtons();
			if (Picker.getProgressPercentage() > 0) {
				this.showPickerResetButton();
			}
			if (Picker.isPickingComplete()) {
				this.alertStatus('order_picked');
			}
			Scanner.ready();
		},

		init: function () {
			let _this = this;
			this.$container = $('#pickingpal-container');

			//Progress Bar
			this.$progressBar = $('#pickingpal-progressbar');
			this.$progressLabel = $('.progress-label');
			if (this.$progressBar.length) {
				this.$progressBar.progressbar({
					value : " ",
					change: function () {
						let progressBarValue = _this.$progressBar.progressbar("value") + "%"
						_this.$progressLabel.text(progressBarValue);
					}
				});
			}

			//Init Status
			this.alertStatus('scan_order');

			//PostData Events
			PostData.events.before_load.add(function () {
				_this.update();
				_this.alertStatus('loading');
			});
			PostData.events.after_load.add(function () {
				_this.update();
				if (Picker.getOrderId()) {
					if (Picker.isPickingComplete()) {
						_this.alertStatus('order_picked');
					} else {
						_this.alertStatus('order_loaded');
					}
				} else {
					_this.alertStatus('order_not_found');
				}
			});
			PostData.events.order_status_changed.add(function () {
				if (Picker.getOrderId()) {
					Ui.alertStatus('order_status_changed_to');
					Ui.displayOrderStatus();
				}
			});

			//Picker Events
			Picker.events.completed.add(function () {
				_this.update();
			});
			Picker.events.after_pick.add(function (params) {
				let item = params.item;
				_this.update();
			});


			//
			//PICKINGPAL EVENTS
			//Events bound to $pickingPalContainer
			//
			if (this.$container.length) {


				//Item pick button
				this.$container.on('click', '.pick_item', function () {
					let itemId = $(this).data('itemid');
					let item = Picker.findItemById(itemId);
					if(item){
						Picker.pickItem(item,1);
						_this.alertStatus('found');
					}
				});

				//Load Order Btn
				this.$container.on('click', '#pickingpal-btn--load-order', function () {
					Scanner.triggerOrderScan();
				});


				//Pick Button
				this.$container.on('click', '#pickingpal-btn--pick', function () {
					Scanner.triggerProductScan();
				})

				//Reset Button
				this.$container.on('click', '#pickingpal-btn--reset-picking-status', function () {
					$(this).addClass('loading');
					PostData.resetOrder();
				});

				//Print Slip Button
				this.$container.on('click', '#pickingpal-btn--print-slip', function () {
					let orderId = Picker.getOrderId();
					let url = $(this).attr('data-url');
					if (orderId == null)
						return false;

					url = url.replace('order_id', orderId);
					let w = window.open(url, 'print', 'width=800,height=600');
					w.focus();
					return false;
				});

				//View Order Button
				this.$container.on('click', '#pickingpal-btn--view-order', function () {
					let orderId = Picker.getOrderId();
					let url = $(this).attr('data-url');
					if (orderId == null)
						return false;

					url = url.replace('{{order_id}}', orderId);
					let w = window.open(url, '_blank');
					return false;
				});

				//Print Unpicked Slip Button
				this.$container.on('click', '#pickingpal-btn--print-unpicked-slip', function () {
					let orderId = Picker.getOrderId();
					let url = $(this).data('url');
					if ( orderId == null ) {
						return false;
					}
					url = url.replace( '%d', orderId );
					let w = window.open( url, 'print', 'width=800,height=600' );
					w.focus();
					return false;
				});

			}


		}
	};

	const UiOverrideItem = {

		closeModal: function () {
			$("#TB_closeWindowButton").click();
		},
		openModal : function () {
			$("#pickingpal-thickbox--override-item").click();
			resizeTB(450);
			this.resetForm();
		},
		resetForm : function () {
			let $codeInput = $('#pickingpal-input--sku-over');
			$codeInput.val('');
			$("#pickingpal-input--qty-over").val('');
			$('#product_title_over').html('');
			$('#product_qty_label_over').text('');
			setTimeout(function () {
				$codeInput.focus();
			}, 150);
		},
		loadItemCode  : function (code) {
			let quantityToPick = Picker.getCodeQuantityToPick(code);
			if (quantityToPick > 0) {
				let items = Picker.findItemsByCode(code);
				let item = items[0];
				let $quantityInput = $('#pickingpal-input--qty-over');
				$('#product_title_over').html(item.getProperty('name'));
				$('#product_qty_label_over').text(quantityToPick);
				$quantityInput.val(quantityToPick);
				$quantityInput.attr({
					'max': quantityToPick
				});
				$quantityInput.focus();
				$quantityInput.select();
				Sounds.itemSuccess();
				return true;
			} else {
				this.resetForm();
				$('#product_title_over').html('Product not found');
			}
			Ui.alertStatus('not_found');
			return false;
		},
		pickCode      : function (code, qty) {
			if ((code.length > 0) && (qty.length > 0)) {
				Picker.pickCode(code, qty);
				this.closeModal();
				Ui.alertStatus('found')
				Scanner.init();
			}
		},
		init      : function () {

			let _this = this;

			//Scanner Events
			//Handle override code scan
			Scanner.events.scan_product.add(function (params) {
				let code = params.value;
				if (code == Picker.overrideCode) {
					_this.openModal();
				}
			});

			//
			//POPUP ELEMENT EVENTS
			//Popups use thickbox which is outside of pickingpal container.
			//Bind events to BODY
			//
			$body = $('body');

			//Popup Load product on Button Press
			$body.on('click', '#pickingpal-btn--load-product-over', function () {
				let $codeInput = $('#pickingpal-input--sku-over');
				let code = $codeInput.val();
				_this.loadItemCode(code);
			});

			//Popup Load product on Key Enter
			$body.on('keypress', '#pickingpal-input--sku-over', function (ev) {
				let code = $(this).val();
				if (Helpers.isEnterKey(ev) && code.length > 0) {
					_this.loadItemCode(code);
				}
			});

			//Popup Pick product on Button Press
			$body.on('click', '#pickingpal-btn--pick-over', function () {
				let code = $('#pickingpal-input--sku-over').val();
				let qty = $('#pickingpal-input--qty-over').val();
				_this.pickCode(code, qty);
			});
			//Popup Pick product on Key Enter
			$body.on('keypress', '#pickingpal-input--qty-over', function (ev) {
				let code = $('#pickingpal-input--sku-over').val();
				let qty = $(this).val();
				if (Helpers.isEnterKey(ev) && code.length > 0 && qty.length > 0) {
					_this.pickCode(code, qty);
				}
			});

		}
	};

	const Picker = {
		order        : null,
		items        : [],
		pickedItemIds: [],
		autoPickDigital : false,
		events       : {
			after_pick: new Helpers.callback(),
			completed : new Helpers.callback(),
		},
		overrideCode : null,
		resetCode    : null,
		changeOrderStatusCodes : [],

		getItemCount        : function () {
			return this.items.length;
		},
		getTotalItemQuantity: function (pickedOnly) {
			let _this = this;
			let quantity = 0;
			$.each(_this.items, function (index, item) {
				if (pickedOnly) {
					quantity += _this.getItemPickedQuantity(item);
				} else {
					quantity += item.getQuantityRequired();
				}
			})
			return quantity;
		},
		getUnpickedItems    : function () {
			let _this = this;
			let unPickedItems = [];
			$.each(_this.items, function (index, item) {
				let unpickedQuantity = _this.getItemQuantityToPick(item);
				if (unpickedQuantity) {
					unPickedItems.push(item);
				}
			})
			return unPickedItems;
		},
		getPickedItems      : function () {
			let _this = this;
			let pickedItems = [];
			$.each(_this.items, function (index, item) {
				let pickedQuantity = _this.getItemPickedQuantity(item);
				if (pickedQuantity) {
					pickedItems.push(item);
				}
			})
			return pickedItems;
		},
		hasPickedItems      : function () {
			return !!this.getPickedItems().length;
		},
		hasUnpickedItems    : function () {
			return !!this.getUnpickedItems().length;
		},
		hasPickedBundle(item, pickContext){
			let _this = this;
			let picked = true;
			if(item.isBundle()){
				$.each(_this.getBundleItems(item), function (index, bundleItem, pickContext) {
					if(_this.getItemQuantityToPick(bundleItem,pickContext)){
						picked = false;
						return false; //break loop
					}
				});
			}
			return picked;
		},
		loadOrder           : function (order) {
			let _this = this;
			this.order = order;
			this.items = order.getItems();
			this.pickedItemIds = [];
			let hasSortOrder = false;
			$.each(this.items, function (index, item) {
				if((_this.autoPickDigital) && item.getProperty('is_digital')){
					_this.pickedItemIds[item.getId()] = item.getQuantityAvailable();
				} else {
					let picked = item.getProperty('qty_picked');
					if (picked) {
						_this.pickedItemIds[item.getId()] = parseInt(picked);
					}
				}
				if( item.getProperty('sort_order')){
					hasSortOrder = true;
				}
			});

			if(hasSortOrder){
				this.applyItemSortOrder();
			}
		},
		getOrderId          : function () { //post ID
			return this.order ? this.order.getId() : null;
		},
		getOrderNumber          : function () { //order number
			return this.order ? this.order.getNumber() : null;
		},
		getOrder() {
			return this.order;
		},
		pickCode: function(code, quantity){
			let items = this.findItemsByCode(code);
			let picked = 0;
			let lastPickedItem = null;
			if(items && items.length){
				$.each(items, function (index, foundItem) {
					let quantityAvailable = Picker.getItemQuantityToPick(foundItem);
					if(quantityAvailable){
						let pickQuantity = Math.min(quantity, quantityAvailable);
						Picker.pickItem(foundItem, pickQuantity);
						lastPickedItem = foundItem;
						picked+= pickQuantity;
						if(picked >= quantity){
							return false; //break loop
						}
					}
				});
				if((picked < quantity) && lastPickedItem){
					//overpick is allowed
					let overpickQuantity = quantity - picked;
					Picker.pickItem(lastPickedItem, overpickQuantity);
					picked = quantity;
				}
			}
		},
		pickItem                  : function (item, quantity) {
			let _this = this;
			let itemId = item.getId();
			let int = parseInt(quantity);
			if (this.pickedItemIds[itemId] === undefined) {
				this.pickedItemIds[itemId] = 0;
			}
			if (int) {
				this.pickedItemIds[itemId] += int;
				this.onAfterPickItem(item, quantity);
			}
		},
		onAfterPickItem           : function (pickedItem, quantity) {
			let _this = this;

			_this.events.after_pick.run({
				item: pickedItem,
				adjustment : quantity
			});

			//When a bundle is picked, pick multiples of child bundle items
			if(pickedItem.isBundle()){
				if(!this.hasPickedBundle(pickedItem)) {
					let bundlePickedQty = Picker.getItemPickedQuantity(pickedItem);
					let bundleItems = _this.getBundleItems(pickedItem);
					if (bundleItems.length) {
						$.each(bundleItems, function (index, bundleItem) {
							let bundleItemQty = bundleItem.getBundleItemQuantity();
							let calculatedPickedQuantity = bundlePickedQty * bundleItemQty;
							let actualPickedQuantity = Picker.getItemPickedQuantity(bundleItem);
							if (actualPickedQuantity < calculatedPickedQuantity) {
								let qtyToPick = Math.min(calculatedPickedQuantity - actualPickedQuantity);
								if (qtyToPick) {
									Picker.pickItem(bundleItem, qtyToPick);
								}
							}
						});
					}
				}
			}

			//When a child bundle item is picked, check if parent bundle is picked
			if(pickedItem.isBundleItem()){
				let bundle = _this.findItemById(pickedItem.getParentId());
				if(bundle){
					let bundleQtyToPick = Picker.getItemQuantityToPick(bundle);
					if(bundleQtyToPick){
						let bundlePickedQuantityCalculated = Picker.calculateBundlePickedQuantity(bundle);
						let bundlePickedQuantity = Picker.getItemPickedQuantity(bundle);
						if(bundlePickedQuantityCalculated > bundlePickedQuantity) {
							bundleQtyToPick = bundlePickedQuantityCalculated - bundlePickedQuantity;
							Picker.pickItem(bundle, bundleQtyToPick);
						}
					}
				}
			}

			if (this.isPickingComplete()) {
				_this.events.completed.run({
					orderId: _this.getOrderId(),
					orderNumber: _this.getOrderNumber(),
				});
			}
		},
		processPickCode           : function (code) {
			if (this.isOverrideCode(code)) {
				return null;
			}
			let isItemPicked = false;
			let foundItems = Picker.findItemsBySKU(code);
			if (!foundItems.length) {
				foundItems = Picker.findItemsByCode(code)
			}
			if (foundItems && foundItems.length) {
				$.each(foundItems, function (index, foundItem) {
					if(Picker.getItemQuantityToPick(foundItem, 'available')){
						Picker.pickItem(foundItem, 1);
						isItemPicked = true;
						return false; //break loop
					}
				});
				if(!isItemPicked){
					$.each(foundItems, function (index, foundItem) {
						if(Picker.getItemQuantityToPick(foundItem, 'backordered')){
							Picker.pickItem(foundItem, 1);
							isItemPicked = true;
							return false; //break loop
						}
					});
				}
			}
			return isItemPicked;
		},
		getItemPickedQuantity     : function (item, context) {
			let itemId = item.getId();
			let qty = 0;
			if (this.pickedItemIds[itemId] !== undefined) {
				qty = this.pickedItemIds[itemId];
			}
			if(qty === 0){
				return 0;
			}
			if(context == 'backordered'){
				qty = qty - item.getQuantityAvailable();
			} else if (context == 'available'){
				qty = Math.min(qty, item.getQuantityAvailable());
			}
			return (qty < 0) ? 0 : qty;
		},
		getItemQuantityToPick     : function (item, context) {
			let qty = item.getQuantityRequired();
			if(context == 'backordered'){
				qty = item.getQuantityBackordered();
			} else if (context == 'available'){
				qty = item.getQuantityAvailable();
			}
			let picked = this.getItemPickedQuantity(item, context);
			if (picked >= qty) {
				return 0;
			}
			return (qty - picked);
		},
		getCodeQuantityToPick : function(code){
			let result = 0;
			let foundItems = this.findItemsByCode(code);
			if (foundItems && foundItems.length) {
				$.each(foundItems, function (index, foundItem) {
					result += Picker.getItemQuantityToPick(foundItem)
				});
			}
			return result;
		},
		calculateBundlePickedQuantity : function(item, context){
			if(item.isBundle()){
				if(this.hasPickedBundle(item,context)){
					return item.getQuantityRequired();
				}
				let bundleItems = this.getBundleItems(item);
				let lowestPickedMultiple = null;
				if(bundleItems.length){
					$.each(bundleItems, function (index, bundleItem) {
						let picked = Picker.getItemPickedQuantity(bundleItem, context);
						let bundleQty = bundleItem.getBundleItemQuantity();
						let multiple =  picked ? (picked / bundleQty) : 0;
						if(lowestPickedMultiple === null || (multiple < lowestPickedMultiple)){
							lowestPickedMultiple = multiple;
						}
					});
				}
				return Math.floor(lowestPickedMultiple ? lowestPickedMultiple : 0);
			}
			return 0;
		},
		findItemById              : function (id) {
			let foundItem = null;
			if(id !== undefined) {
				let findItemId = id.toString();
				let searchItems = this.items;
				$.each(searchItems, function (index, searchItem) {
					let searchItemId = searchItem.getId();
					if(searchItemId !== null) {
						let matchId = searchItemId.toString();
						if (findItemId === matchId) {
							foundItem = searchItem;
							return false; //break;
						}
					}
				});
			}
			return foundItem;
		},
		findItemsBySKU             : function (sku) {
			let foundItems = [];
			if (sku) {
				let skuSearch = sku.toString().toUpperCase().trim();
				let searchItems = this.items;
				$.each(searchItems, function (index, searchItem) {
					let matchSKU = searchItem.getSKU();
					if (matchSKU.length) {
						matchSKU = matchSKU.toString().toUpperCase().trim();
						if (matchSKU === skuSearch) {
							foundItems.push(searchItem);
						}
					}
				});
			}
			return foundItems;
		},
		findItemsByCode            : function (code) {
			let foundItems = [];
			if (code) {
				let codeSearch = code.toString().toUpperCase().trim();
				let searchItems = this.items;
				$.each(searchItems, function (index, searchItem) {
					let matchCodes = searchItem.getLookupCodes();
					$.each(matchCodes, function (index, matchCode) {
						if (matchCode) {
							matchCode = matchCode.toString().toUpperCase().trim();
							if (matchCode === codeSearch) {
								foundItems.push(searchItem);
							}
						}
					});
				});
			}
			return foundItems;
		},
		getBundleItems : function(item){
			let bundleItems = [];
			if(item.isBundle()) {
				let bundleId = item.getId();
				let searchItems = this.items;
				$.each(searchItems, function (index, searchItem) {
					if(searchItem.isBundleItem() && searchItem.getParentId() == bundleId){
						bundleItems.push(searchItem);
					}
				});
			}
			return bundleItems;
		},
		isPickingComplete         : function () {
			if (this.hasUnpickedItems()) {
				return false;
			}
			return (this.getTotalItemQuantity(true) >= this.getTotalItemQuantity())
		},
		filterBackorderedItems: function (items, include) {
			let filteredItems = [];
			$.each(items, function (index, filterItem) {
				if((filterItem.getQuantityBackordered() > 0) && (include === true)){
					filteredItems.push(filterItem);
				} else {
					filteredItems.push(filterItem);
				}
			});
			return filteredItems;
		},
		getProgressPercentage     : function () {
			if (this.isPickingComplete()) {
				return 100;
			}
			let totalPickedQuantity = this.getTotalItemQuantity(true);
			if (totalPickedQuantity > 0) {
				let percent = Math.ceil((totalPickedQuantity / this.getTotalItemQuantity()) * 100);
				return Math.min(99, percent);
			}
			return 0;
		},
		getPickedSKUs             : function () {
			let pickedSKUs = [];
			let pickedItems = this.getPickedItems();
			if (pickedItems.length) {
				$.each(pickedItems, function (index, pickedItem) {
					pickedSKUs.push(pickedItem.getSKU());
				});
			}
			return pickedSKUs;
		},
		isOverrideCode(code){
			let overrideCodes = [this.overrideCode, this.resetCode].concat(this.changeOrderStatusCodes);
			if ($.inArray(code, overrideCodes) !== -1) {
				return true;
			}
			return false;
		},
		applyItemSortOrder(){
			this.items.sort((a, b) => {
				return a.getProperty('sort_order') - b.getProperty('sort_order');
			});
		},
		reset                     : function () {
			this.order = null;
			this.items = [];
			this.pickedItemIds = [];
			Ui.update();
		},
		init                      : function () {
			let _this = this;

			//Handle product code scans
			Scanner.events.scan_product.add(function (params) {
				let code = params.value;
				let productFound = _this.processPickCode(code);
				let alertStatus = null;
				if (productFound !== null) {
					alertStatus = productFound ? 'found' : 'not_found';
				}
				if (!_this.isPickingComplete() && (alertStatus !== null)) {
					Ui.alertStatus(alertStatus);
				}
			});

			PostData.events.order_status_changed.add(function () {
				let order = _this.getOrder();
				if(order && !order.isPickingEnabled()){
					let newOrderStatus = order.getStatus();
					_this.reset();
					if(newOrderStatus){
						Ui.alertStatus('order_status_changed_to')
						Ui.displayOrderStatus(newOrderStatus);
					}
				}
			});
		}
	}

	const PostData = {
		events            : {
			after_load : new Helpers.callback(),
			before_load: new Helpers.callback(),
			order_status_changed: new Helpers.callback(),
		},
		loadCompleted     : null,
		loadOrder         : function (orderNumber) { // loading order
			_this = this;
			this.loadCompleted = false;
			Picker.reset();

			_this.events.before_load.run();

			let data = {
				action     : ajax_object_pickingpal.script_name,
				_ajax_nonce: ajax_object_pickingpal.nonce,
				method     : 'load_order',
				tab        : active_tab,
				page       : menu_slug,
				order_id   : null,
				order_number   : orderNumber,
			};

			let request = $.ajax({
				url     : ajax_object_pickingpal.ajax_url,
				method  : "POST",
				data    : data,
				dataType: "json",
			});

			request.done(
				function (response) {
					if (!response.success) {
						Ui.alertStatus('not_valid_order_status', response.data);
						return false;
					}

					if (null === response.data.order_items) {
						Ui.alertStatus('order_not_found');
						return false;
					}
					_this.loadCompleted = true;
					let responseData = response.data;
					let itemsData = responseData.order_items;
					let overrideSKU = itemsData.hasOwnProperty('override_sku') ? itemsData.override_sku : null;
					let resetSKU = itemsData.hasOwnProperty('pick_reset_override_sku') ? itemsData.pick_reset_override_sku : null;
					let changeOrderStatusCodes = itemsData.hasOwnProperty('status_switch_barcode_units') ? itemsData.status_switch_barcode_units : null;
					let autopickDigital = itemsData.hasOwnProperty('autopick_digital') ? itemsData.autopick_digital : null;

					Picker.overrideCode = overrideSKU;
					Picker.resetCode = resetSKU;
					Picker.autoPickDigital = autopickDigital;
					if(changeOrderStatusCodes){
						$.each(changeOrderStatusCodes, function (index, barcodeObj) {
							let statusBarcode = barcodeObj.hasOwnProperty('barcode') ? barcodeObj.barcode : null;
							if(statusBarcode){
								Picker.changeOrderStatusCodes.push(statusBarcode);
							}
						});
					}

					let order = new Order(responseData);
					Picker.loadOrder(order);

					_this.events.after_load.run();
				}
			);
		},
		changeOrderStatus : function(barcode){
			Ui.alertStatus('loading');
			let method = 'barcode_change_status';

			let data = {
				action: ajax_object_pickingpal.script_name,
				_ajax_nonce: ajax_object_pickingpal.nonce,
				method: method,
				tab: active_tab,
				page: menu_slug,
				order_id: Picker.getOrderId(),
				order_number: Picker.getOrderNumber(),
				trigger_barcode: barcode,
			};

			let request = jQuery.ajax({
				url: ajax_object_pickingpal.ajax_url,
				method: "POST",
				data: data,
				dataType: "json",
			});

			let statusChanged = false;
			request.done(function (response) {
				if (response) {
					if (response.data.new_status) {
						let newStatus = response.data.new_status;
						let order = Picker.getOrder();
						if (order && newStatus.length) {
							if (order.getStatus() != newStatus) {
								order.setStatus(newStatus);
								let pickingEnabled = response.data.picking_enabled;
								if(pickingEnabled === '1' || pickingEnabled === '0') {
									pickingEnabled = pickingEnabled === '1';
									order.setPickingEnabled(pickingEnabled);
								}
								_this.events.order_status_changed.run();
								statusChanged = true;
							}
						}
					}
				}
				if(!statusChanged) {
					Ui.alertStatus('order_status_change_failed');
				}
			});
		},
		resetOrder        : function () {
			Ui.alertStatus('loading');
			let data = {
				action     : ajax_object_pickingpal.script_name,
				_ajax_nonce: ajax_object_pickingpal.nonce,
				method     : 'reset_order',
				tab        : active_tab,
				page       : menu_slug,
				order_id    : Picker.getOrderId(),
				order_number    : Picker.getOrderNumber(),
			};

			let request = $.ajax({
				url     : ajax_object_pickingpal.ajax_url,
				method  : "POST",
				data    : data,
				dataType: "json",
			});

			request.done(function (response) {
				if (response) {
					PostData.loadOrder(Picker.getOrderNumber());
				}
			});
		},
		logPickedItem     : function (Item, adjustment) {
			let method = 'pick';
			let pickedItemData = Item.getData();
			let pickedItems = Picker.getPickedItems();
			let pickedSKUs = Picker.getPickedSKUs();
			let pickedItemsData = [];

			pickedItemData.qty_adjustment = adjustment;
			pickedItemData.qty_picked =  Picker.getItemPickedQuantity(Item);
			pickedItemData.qty_required =  Item.getQuantityRequired();
			pickedItemData.qty = pickedItemData.qty_picked; //deprecated

			$.each(pickedItems, function (index, pickedItem) {
				let pickedItemData = pickedItem.getData();
				pickedItemData.qty_picked =  Picker.getItemPickedQuantity(pickedItem);
				pickedItemData.qty_required =  pickedItem.getQuantityRequired();
				pickedItemData.qty = pickedItemData.qty_picked; //deprecated
				pickedItemsData.push(pickedItemData);
			});
			let data = {
				action     : ajax_object_pickingpal.script_name,
				_ajax_nonce: ajax_object_pickingpal.nonce,
				method     : method,
				tab        : active_tab,
				page       : menu_slug,
				picked_item: pickedItemData,
				picked_items: pickedItemsData,
				picked_skus        : pickedSKUs,
				order_id   : Picker.getOrderId(),
				order_number   : Picker.getOrderNumber(),
				percent    : Picker.getProgressPercentage(),
			};

			let request = $.ajax({
				url     : ajax_object_pickingpal.ajax_url,
				method  : "POST",
				data    : data,
				dataType: "json",
			});

			request.done(function (response) {
				if (response) {
					console.log(response)
				}
			});
		},
		logPickingComplete: function (orderId, orderNumber) {

			let method = 'set_picking_complete';

			let data = {
				action     : ajax_object_pickingpal.script_name,
				_ajax_nonce: ajax_object_pickingpal.nonce,
				method     : method,
				tab        : active_tab,
				page       : menu_slug,
				order_id   : orderId,
				order_number   : orderNumber,
			};

			let request = $.ajax({
				url     : ajax_object_pickingpal.ajax_url,
				method  : "POST",
				data    : data,
				dataType: "json",
			});

			request.done(function (response) {
				if (response.data && response.data.hasOwnProperty('order_status')) {
					let newStatus = response.data.order_status;
					let order = Picker.getOrder();
					if (order && newStatus.length) {
						if (order.getStatus() != newStatus) {
							order.setStatus(newStatus);
							_this.events.order_status_changed.run();
						}
					}
				}
			});

		},
		init              : function () {
			let _this = this;
			Picker.events.after_pick.add(function (params) {
				let item = params.item;
				let adjustment = params.adjustment;
				if (item !== false) {
					_this.logPickedItem(item, adjustment);
				}
			});
			Picker.events.completed.add(function (params) {
				let orderId = params.orderId;
				let orderNumber = params.orderNumber;
				if (orderNumber || orderId) {
					_this.logPickingComplete(orderId, orderNumber);
				}
			});
			Scanner.events.scan_order.add(function (params) {
				let orderNumber = params.value;
				_this.loadOrder(orderNumber);
			});
			Scanner.events.scan_product.add(function (params) {
				let code = params.value;
				if (code == Picker.resetCode) {
					_this.resetOrder();
				}
				else if ($.inArray(code, Picker.changeOrderStatusCodes) !== -1) {
					_this.changeOrderStatus(code);
				}
			});
		}
	}

	function init() {
		Picker.init();
		Ui.init();
		UiOverrideItem.init();
		Scanner.init();
		PostData.init();
	}

	$(document).ready(function ($) {
		init();
	});

})(jQuery);




