/**
 * UI helper methods for Woocommerce Shop Order views.
 */
(function ($) {

	const ShopOrder = {

		printPickTickets: function (postIds) {
			if(!postIds.length){
				alert('Please select at least one order');
				return false;
			}
			let url ='/wp-admin/?method=pickingpal_print_pick_ticket';
			let params = $.param( {'ids' : postIds} );
			this.popupPrintUrl(url+'&'+params );
		},
		printPickLists: function(postIds) {
			if(!postIds.length){
				alert('Please select at least one order');
				return false;
			}
			let url ='/wp-admin/?method=pickingpal_print_pick_list';
			let params = $.param( {'ids' : postIds} );
			this.popupPrintUrl(url+'&'+params );
		},
		popupPrintUrl: function(url){
			let w = window.open(url, 'print', 'width=800,height=600');
			w.focus()
			return false;
		},
		addPostsFilterEvents: function() {
			//legacy
			$( '#posts-filter' ).on( 'submit', function (e) {
				let postIds = $("input[name='post[]']:checked").map(function(){return $(this).val();}).get();
				if ($( '[name="post_type"]' ).val() == 'shop_order') {

					if($( '[name="action"]' ).val() == 'print_pick_ticket'){
						ShopOrder.printPickTickets(postIds);
						e.preventDefault();
					}

					if($( '[name="action"]' ).val() == 'print_pick_list') {
						ShopOrder.printPickLists(postIds);
						e.preventDefault();
					}
				}
			});
			//hpos
			$( '#wc-orders-filter' ).on( 'submit', function (e) {
				let orderIds = $("input[name='id[]']:checked").map(function(){return $(this).val();}).get();
				if ($( '[name="page"]' ).val() == 'wc-orders') {

					if($( '[name="action"]' ).val() == 'print_pick_ticket'){
						ShopOrder.printPickTickets(orderIds);
						e.preventDefault();
					}

					if($( '[name="action"]' ).val() == 'print_pick_list') {
						ShopOrder.printPickLists(orderIds);
						e.preventDefault();
					}
				}
			});
		},
		addActionColumnEvents: function() {

			let _this = this;

			//print ticket icon button
			let $printTicketButton = $(".print_pick_ticket");
			$printTicketButton.click(function(e) {
				let orderId = $(this).data('order-id');
				_this.printPickTickets([orderId]);
			})

		},
		initTooltips : function(){
			// Tooltips
			let $printPickTicketBtns = $('a.print_pick_ticket');
			if($printPickTicketBtns.length) {
				$printPickTicketBtns.each(function () {
					$(this).tipTip({
						'fadeIn' : 50,
						'fadeOut': 50,
						'delay'  : 200
					});
				});
			}
		},
		initEvents: function() {
			this.addPostsFilterEvents();
			this.addActionColumnEvents();
			this.initTooltips();
		}
	}

	$(document).ready(function ($) {
		ShopOrder.initEvents();
	});

})(jQuery);
