<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}



/**
 * WCPP_admin
 *
 * WooCommerce Picking Pal Admin
 *
 * @class       WCPP_admin
 * @category    Class
 */
class WCPP_admin {

	/**
	 * @var object Active tab class instance
	 */
	private $active_tab_class;

	/**
	 * @var string Active tab class name
	 */
	private $active_tab;

	/**
	 * @var array Array of tab names on main page
	 */
	public $tab_names = array();

	/**
	 * @const Admin Menu slug
	 */
	const MENU_SLUG = 'PickingPal';

	public function __construct() {

		$this->tab_names = array(
			'pickingpal' => __( 'PickingPal', 'woocommerce-pickingpal' ),
			'log'        => __( 'Log', 'woocommerce-pickingpal' ),
			'settings'   => __( 'Settings', 'woocommerce-pickingpal' ),
			'export'     => __( 'Export', 'woocommerce-pickingpal' ),
			'license'    => __( 'License', 'woocommerce-pickingpal' ),
		);

		$this->init();
	}

	public function init_tab() {
		if ( ! isset( $_REQUEST['page'] ) or $_REQUEST['page'] != self::MENU_SLUG ) {
			return null;
		}

		// check the logged in user capability and display appropriate tabs
		// include pluggable.php for the current_user_can function to work.
		if ( ! function_exists( 'wp_get_current_user' ) ) {
			require_once ABSPATH . 'wp-includes/pluggable.php';
		}
		global $current_user_can;
		if ( ! current_user_can( 'create_users' ) ) {
			unset( $this->tab_names['settings'] );
			unset( $this->tab_names['license'] );
		}

		// TODO: check if we are on PP page
		if ( isset( $_REQUEST['tab'] ) ) {
			$active_tab = $_REQUEST['tab'];
		} else {
			$active_tab = 'pickingpal';
		}

		$this->active_tab = $active_tab;
		switch ( $active_tab ) {
			case 'pickingpal':
				include_once self::admin_tab_classes_path() . '/class-wcpp-pickingpal-tab.php';
				$this->active_tab_class = new WCPP_Pickingpal_Tab();
				break;
			case 'log':
				include_once self::admin_tab_classes_path() . '/class-wcpp-log-tab.php';
				$this->active_tab_class = new WCPP_Log_Tab();
				break;
			case 'settings':
				include_once self::admin_tab_classes_path() . '/class-wcpp-settings-tab.php';
				$this->active_tab_class = new WCPP_Settings_Tab();
				break;
			case 'export':
				include_once self::admin_tab_classes_path() . '/class-wcpp-export-tab.php';
				$this->active_tab_class = new WCPP_Export_Tab();
				break;
			case 'license':
				include_once self::admin_tab_classes_path() . '/class-wcpp-license-tab.php';
				$this->active_tab_class = new WCPP_License_Tab();
				break;
			default:
				$this->active_tab_class = false;
		}
		// do POST
		if ( $this->active_tab_class ) {
			$this->active_tab_class->post_handler();
		}
		// TODO: end check , see above
	}

	/**
	 * Hook actions and filters
	 */
	private function init() {
		$this->includes();

		add_action( 'admin_init', array( $this, 'init_tab' ) );
		add_action( 'admin_menu', array( $this, 'add_submenu_to_woocommerce' ) );
		add_action( 'admin_init', array( $this, 'print_gate' ) );
		add_action( 'woojetpack_after_settings_save', array( $this, 'clear_order_numbers_transient' ), 10, 2 );

		// add ajax hanlders
		foreach ( $this->tab_names as $tab_name => $tab_name_translated ) {
			add_action( 'wp_ajax_' . 'ajax_script_' . $tab_name, array( $this, 'ajax_gate' ) );
		}

		// apply settings to UI
		$settings = array();
		new WCPP_Admin_Tweak_UI( $settings );
	}

	/**
	 * Include any classes we need within admin.
	 */
	private function includes() {
		include_once self::admin_tab_classes_path() . '/class-wcpp-tab.php';
		include_once 'class-wcpp-admin-tweak-ui.php';
		include_once 'class-wcpp-print-handler.php';
		include_once 'class-wcpp-admin-helper.php';
		include_once 'class-wcpp-picker-data.php';
		include_once 'class-wcpp-print-template.php';
		include_once 'class-wcpp-print-template-data.php';
	}

	public function ajax_gate() {
		if ( isset( $_REQUEST['method'] ) ) {
			$method = $_REQUEST['method'];
			if ( method_exists( $this->active_tab_class, $method ) ) {
				$_POST = array_map( 'stripslashes_deep', $_POST );
				$this->active_tab_class->$method();
			} else {
				echo 'AJAX method does not exists';
			}
		}
		die();
	}

	public function print_gate() {
		$print_handler = new WCPP_Print_Handler();
		$method        = isset( $_REQUEST['method'] ) ? $_REQUEST['method'] : null;
		if ( $method ) {
			$print_handler->handle( $method );
		}
	}

	/**
	 * Get the admin page views paths
	 *
	 * @return string
	 */
	public static function admin_views_path() {
		return untrailingslashit( WCPP()->plugin_views_path() . '/' );
	}

	/**
	 * Get the admin page js paths
	 *
	 * @return string
	 */
	public static function admin_js_url() {
		return untrailingslashit( WCPP()->plugin_js_url() . '/' );
	}

	/**
	 * Get the admin page tab classes paths
	 *
	 * @return string
	 */
	public static function admin_tab_classes_path() {
		return untrailingslashit( WCPP()->plugin_path() . '/includes/admin/tabs/' );
	}

	/**
	 * Add submenu to WooCommerce menu
	 */
	public function add_submenu_to_woocommerce() {

		add_submenu_page(
			'woocommerce',
			'PickingPal', // title menu
			'PickingPal', // submenu label
			'edit_published_pages',
			self::MENU_SLUG,
			array( $this, 'render_submenu_to_woocommerce' )
		);
	}

	/**
	 * Render Pinking Pal tabs without content
	 */
	public function render_submenu_to_woocommerce() {

		$this->render_admin_view(
			'main',
			array(
				'tab_names'        => $this->tab_names,
				'WCPP_admin'       => $this,
				'ajaxurl'          => WCPP()->ajax_url(),
				'menu_slug'        => self::MENU_SLUG,
				'active_tab_class' => $this->active_tab_class,
			)
		);
	}


	public function render_admin_view( $view_name, $params = array() ) {
		extract( $params );
		$path_to_view = null;
		if ( 'main' == $view_name ) {
			$path_to_view = self::admin_views_path() . '/main.php';
		} elseif ( in_array( $view_name, array_keys( $this->tab_names ) ) ) {
			$this->active_tab_class->register();
			$path_to_view = $this->active_tab_class->return_path_to_view();
		}

		if ( ! $path_to_view ) {
			/*
			* Display a simple 404 error for the restricted tabs
			* if accessed via url
			* @TODO consider adding a $path_to_view
			*/
			echo "<div style='margin-top: 105px; margin-left:50%;'><h4>404 page not found</h4></div>";

			return;
		}

		include_once $path_to_view;
	}

	// for JetPack plugin!
	public function clear_order_numbers_transient( $sections, $current_section ) {
		delete_transient( 'pickingpal_orders_numbers_transient' );
	}
}

new WCPP_admin();
