<?php


class WCPP_Export_Tab extends WCPP_Tab {

	/**
	 * @var string Path to class views
	 */
	public $tab_name = 'export';

	public function export_table() {
		global $hook_suffix;
		$hook_suffix = 'woocommerce_page_PickingPal';
		include 'class-wcpp-list-export.php';

		$log = new WC_List_Export();
		echo $log->output_report();

		wp_die();
	}

	public function save_qty() {
		if ( isset( $_REQUEST['post_id'] ) and isset( $_REQUEST['value'] ) ) {
			$post_id = $_REQUEST['post_id'];
			$value   = $_REQUEST['value'];
			$result  = update_post_meta( $post_id, 'qty', $value );
			echo $result;
		}
		wp_die();
	}

	public function export_csv_handler() {
		if ( isset( $_REQUEST['products'] ) ) {
			$ids      = $_REQUEST['products'];
			$products = $this->get_products( $ids );
			$this->export_csv( $products );
		}
	}
	protected function get_products( $ids ) {
		$products = array();

		// $active_fields = get_option('wc-picking-pal-active-fields');
		$active_fields = WCPP()->settings_handler->get_option( 'active_fields' );
		$fields        = array();
		foreach ( $active_fields as $field => $v ) {
			$fields[] = $field;
		}
		$fields[]   = 'qty';
		$products[] = $fields;
		foreach ( $ids as $key => $id ) {
			$product = wc_get_product( $id );
			switch ( self::get_product_type( $product ) ) {
				case 'variation':
					$this->get_product_variation( $product, $active_fields, $products );
					break;
				default:
					$this->get_product_simple( $product, $active_fields, $products );
			}
		}

		return $products;
	}
	public static function is_custom_field( $field ) {
		$custom_fields = apply_filters( 'wc_pickingpal_custom_fields', array() );
		if ( isset( $custom_fields[ $field ] ) ) {
			return true;
		} else {
			return false;
		}
	}
	protected static function get_product_type( $product ) {
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			$type = $product->product_type;
		} else {
			$type = $product->get_type();
		}
		return $type;
	}
	protected function get_product_variation( $product, $active_fields, &$products ) {
		$attr = $product->get_variation_attributes();
		$key  = count( $products ) - 1;
		foreach ( $active_fields as $field => $v ) {
			$products[ $key + 1 ][ $field ] = '';
			if ( $field == 'sku' ) {
				$products[ $key + 1 ]['sku'] = $product->get_sku();
			}
			if ( $field == 'name' ) {
				$products[ $key + 1 ]['name'] = $product->get_title();
			}
			if ( $field == 'price' ) {

				$price = $product->get_price();
				if ( ! empty( $price ) ) {
					$products[ $key + 1 ]['price'] = '$' . number_format( $price, 2 );
				}
			}
			if ( self::is_custom_field( $field ) ) {
				$products[ $key + 1 ][ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', $product, $field );
			}
			if ( isset( $attr[ "attribute_pa_$field" ] ) ) {
				if ( empty( $attr[ "attribute_pa_$field" ] ) ) {
					$pa_field_name                  = 'pa_' . $field;
					$f                              = array_map(
						function ( $t ) {
							return $t->name;
						},
						get_terms( array( 'taxonomy' => $pa_field_name ) )
					);
					$products[ $key + 1 ][ $field ] = implode( ', ', $f );
				} else {
					$products[ $key + 1 ][ $field ] = $attr[ "attribute_pa_$field" ];
				}
			}
		}

		foreach ( $active_fields as $field => $v ) {
			if ( empty( $products[ $key + 1 ][ $field ] ) ) {

				$vs = wc_get_product_terms( $product->get_id(), "pa_$field" );

				if ( $vs ) {

					$products[ $key + 1 ][ $field ] = implode( ', ', $vs );
				}
			}
		}

		$id  = $product->get_id();
		$qty = get_post_meta( $id, 'qty', true );

		$products[ $key + 1 ]['qty'] = empty( $qty ) ? 100 : $qty;
	}
	protected function get_product_simple( $product, $active_fields, &$products ) {
		$attr = $product->get_attributes();
		$key  = count( $products ) - 1;
		foreach ( $active_fields as $field => $v ) {
			$products[ $key + 1 ][ $field ] = '';
			if ( $field == 'sku' ) {
				$products[ $key + 1 ]['sku'] = $product->get_sku();
			}
			if ( $field == 'name' ) {
				$products[ $key + 1 ]['name'] = $product->get_title();
			}
			if ( $field == 'price' ) {

				$price = $product->get_price();
				if ( ! empty( $price ) ) {
					$products[ $key + 1 ]['price'] = '$' . number_format( $price, 2 );
				}
			}
			if ( self::is_custom_field( $field ) ) {
				$products[ $key + 1 ][ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', $product, $field );
			}
			if ( isset( $attr[ "pa_$field" ] ) ) {

				$t     = get_terms( array( 'taxonomy' => "pa_$field" ) );
				$terms = '';
				if ( $t ) {
					$terms = array_map(
						function ( $term ) {
							return $term->name;
						},
						$t
					);
					$terms = implode( ', ', $terms );
				}
				$products[ $key + 1 ][ $field ] = $terms;
			}
		}

		$id                          = $product->get_id();
		$qty                         = get_post_meta( $id, 'qty', true );
		$products[ $key + 1 ]['qty'] = empty( $qty ) ? 100 : $qty;
	}
	protected function export_csv( $data_rows ) {
		$filename = 'products.csv';
		$fh       = @fopen( 'php://output', 'w' );

		header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header( 'Content-Description: File Transfer' );
		header( 'Content-type: text/csv' );
		header( "Content-Disposition: attachment; filename={$filename}" );
		header( 'Expires: 0' );
		header( 'Pragma: public' );

		foreach ( $data_rows as $data_row ) {
			fputcsv( $fh, $data_row );
		}
		fclose( $fh );
		die();
	}
}
