<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}
// require_once(ABSPATH . 'wp-admin/includes/template.php' );
if ( ! class_exists( 'WP_Screen' ) ) {
	require_once ABSPATH . 'wp-admin/includes/screen.php';
}

class WC_List_Activity_Log extends WP_List_Table {

	/**
	 * @var int
	 */
	protected $order_id;

	/**
	 * @param int $order_id
	 */
	public function __construct( $order_id ) {
		$this->order_id = is_int( $order_id ) ? $order_id : 0;

		parent::__construct(
			array(
				'singular' => __( 'item', 'woocommerce-pickingpal' ),
				'plural'   => __( 'items', 'woocommerce-pickingpal' ),
				'ajax'     => true,
			)
		);
	}

	/**
	 * Output the report
	 */
	public function output_report() {
		$this->prepare_items();

		echo '<form method="post" id="pickingpal">';

		$this->search_box( __( 'Search', 'woocommerce-pickingpal' ), 'search' );
		$this->display();

		echo '</form>';
	}

	/**
	 * get_columns function.
	 */
	public function get_columns() {
		return array(
			'tracking_order_number' => __( 'Order#', 'woocommerce-pickingpal' ),
			'action_date_gmt'       => __( 'Date', 'woocommerce-pickingpal' ),
			'display_name'          => __( 'Scanned by', 'woocommerce-pickingpal' ),
			'action'                => __( 'Action', 'woocommerce-pickingpal' ),
			'data'                  => __( 'Data', 'woocommerce-pickingpal' ),
		);
	}

	public function prepare_items() {
		global $wpdb;

		$columns             = $this->get_columns();
		$hidden              = array( '' );
		$sortable            = $this->get_sortable_columns();
		$order_meta_table    = WCPP()->is_hpos_enabled() ? $wpdb->prefix . 'wc_orders_meta' : $wpdb->postmeta;
		$order_meta_id_field = WCPP()->is_hpos_enabled() ? 'order_id' : 'post_id';

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$log_table_name            = WCPP_Order_Actions_Log_Store::get_table_name();
		$postmeta_key_order_number = WCPP_Order_Extend::ORDER_META_ORDER_NUMBER;
		$per_page                  = 10;

		$select = "SELECT {$log_table_name}.*,pp_postmeta_1.meta_value as tracking_order_number, pp_users_1.display_name";
		$from   = "FROM {$log_table_name}, {$order_meta_table} as pp_postmeta_1, {$wpdb->users} as pp_users_1";

		$where_tracking_order_number = $wpdb->prepare( "(pp_postmeta_1.{$order_meta_id_field} = {$log_table_name}.order_id AND pp_postmeta_1.meta_key = %s ) ", $postmeta_key_order_number );

		if ( $this->order_id ) {
			$where_tracking_order_number .= $wpdb->prepare( " AND ({$log_table_name}.order_id = %s )", $this->order_id );
		}

		$where_display_name = "(pp_users_1.ID = {$log_table_name}.user_id) ";
		$where              = "{$where_tracking_order_number} AND {$where_display_name}";
		if ( ! empty( $_REQUEST['s'] ) ) {
			$s      = '%' . esc_sql( $_REQUEST['s'] ) . '%';
			$where .= $wpdb->prepare(
				" AND
					(pp_postmeta_1.meta_value LIKE '%s'
					OR
					{$log_table_name}.user_id IN (SELECT ID FROM {$wpdb->users} WHERE {$wpdb->users}.display_name LIKE '%s')
					OR
					{$log_table_name}.action_date_gmt LIKE '%s') 
				",
				$s,
				$s,
				$s
			);
		}

		$column    = isset( $_REQUEST['orderby'] ) ? $_REQUEST['orderby'] : 'action_date_gmt';
		$direction = isset( $_REQUEST['order'] ) ? $_REQUEST['order'] : 'desc';

		if ( $direction == 'asc' ) {
			$order_by = sprintf( 'ORDER BY %s ASC, id ASC', sanitize_key( $column ) );
		} else {
			$order_by = sprintf( 'ORDER BY %s DESC, id DESC', sanitize_key( $column ) );
		}

		if ( isset( $_REQUEST['paged'] ) ) {
			$paged        = $_REQUEST['paged'] > 0 ? $_REQUEST['paged'] : 1;
			$start_offset = ( $paged - 1 ) * $per_page;
		} else {
			$start_offset = 0;
		}

		$limit = $wpdb->prepare( 'LIMIT %d,%d', $start_offset, $per_page );

		if ( $where ) {
			$where = " WHERE $where";
		}
		$sql = "{$select} {$from} {$where} {$order_by} {$limit}";
		$r   = $wpdb->get_results( $sql, ARRAY_A );

		$data = array();

		foreach ( $r as $row ) {
			$order_action_log_store = WCPP_Order_Actions_Log_Store::fill_from_row( new WCPP_Order_Actions_Log_Store(), $row );

			$order_id = $row['order_id'];

			$item                          = array();
			$item['order_post_id']         = $order_action_log_store->get_order_id();// id as number!
			$item['tracking_order_number'] = $row['tracking_order_number'];
			$item['action_date_gmt']       = $row['action_date_gmt'];
			$item['action']                = $order_action_log_store->get_humanized_action();

			$table_data = array();
			foreach ( $order_action_log_store->get_humanized_data() as $datum ) {
				$table_data[] = sprintf( '%s : %s', $datum['label'], $datum['value'] );
			}
			$item['data'] = implode( '<br>', $table_data );

			$user                 = new WP_User( $order_action_log_store->get_user_id() );
			$item['display_name'] = $user->display_name;

			$data[] = $item;
		}

		$this->items = $data;
		if ( $this->order_id ) {
			$amount_rows_where = $wpdb->prepare( "({$log_table_name}.order_id = %s )", $this->order_id );
		} else {
			$amount_rows_where = '1=1';
		}
		$amount_rows = $wpdb->get_var( "SELECT COUNT(id) FROM {$log_table_name} WHERE {$amount_rows_where}" );
		/**
		 * Pagination
		 */
		$this->set_pagination_args(
			array(
				'total_items' => count( $r ),
				'per_page'    => $per_page,
				'total_pages' => ceil( $amount_rows / $per_page ),
			)
		);
	}

	function column_default( $item, $column_name ) {
		return isset( $item[ $column_name ] ) ? $item[ $column_name ] : '';
	}

	function column_date_scanned( $item ) {
		$r = "<a class=\"modal_open thickbox\" href=\"#TB_inline?width=0&height=0&inlineId=modal&order_id={$item[ 'tracking_order_number' ]}\" data-id=\"{$item[ 'tracking_order_number' ]}\">" . $item['date_scanned'] . '</a>';

		if ( ! $item['processing'] ) {
			$r .= '<span class="dashicons dashicons-yes"></span>';
		}

		return $r;
	}

	public function get_sortable_columns() {
		return array(
			'tracking_order_number' => array( 'tracking_order_number', false ),
			'action_date_gmt'       => array( 'action_date_gmt', false ),
			'display_name'          => array( 'display_name', false ),
			'action'                => array( 'action', false ),
		);
	}
}
