<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}
// require_once(ABSPATH . 'wp-admin/includes/template.php' );
if ( ! class_exists( 'WP_Screen' ) ) {
	require_once ABSPATH . 'wp-admin/includes/screen.php';
}

class WC_List_Export extends WP_List_Table {

	public function __construct() {

		parent::__construct(
			array(
				'singular' => __( 'item', 'woocommerce-pickingpal' ),
				'plural'   => __( 'items', 'woocommerce-pickingpal' ),
				'ajax'     => true,
			)
		);
	}

	/**
	 * Output the report
	 */
	public function output_report() {
		$this->prepare_items();
		?>

		<div class="wp-wrap">
			<?php
			$this->display();
			?>
		</div>
		<?php
	}

	public function display_tablenav( $which ) {
		if ( 'top' != $which ) {
			return;
		}

		echo '<form method="post" id="pickingpal">';
		$product_name = isset( $_REQUEST['product_name'] ) ? $_REQUEST['product_name'] : '';
		$category     = isset( $_REQUEST['product_cat_parent'] ) ? $_REQUEST['product_cat_parent'] : '';
		?>

		<div class="wc-pp-filters" style="display: block;">
				<div style="display: inline-block;"><?php _e( 'Product', 'woocommerce-pickingpal' ); ?>:</div>
			<div style="display: inline-block;">
					<input type="text" style="padding: 4px;" id="product_name" name="product_name" placeholder="<?php _e( 'Enter Product Name', 'woocommerce-pickingpal' ); ?>" value="<?php echo $product_name; ?>">
					</div>
				<div style="display: inline-block;"><?php _e( 'Categories', 'woocommerce-pickingpal' ); ?>:</div>
					<div style="display: inline-block;">
					<?php
					$taxonomy = get_taxonomy( 'product_cat' );

					wp_dropdown_categories(
						array(
							'selected'         => $category,
							'taxonomy'         => $taxonomy->name,
							'hide_empty'       => 0,
							'name'             => '' . $taxonomy->name . '_parent',
							'orderby'          => 'name',
							'hierarchical'     => 1,
							'show_option_none' => '&mdash; ' . $taxonomy->labels->parent_item . ' &mdash;',
							'class'            => 'wc-pp-filters-select',
						)
					);
					?>

				</div>
				<div style="display: inline-block;">
					<input type="button" class="btn btn-default" id="search-submit" value="<?php _e( 'Filter Products', 'woocommerce-pickingpal' ); ?>">
				</div>

		</div>
		<?php
		echo '</form>';
	}

	/**
	 * get_columns function.
	 */
	public function get_columns() {
		$columns = array();
		// $active_fields   = get_option( 'wc-picking-pal-active-fields' );
		$active_fields = WCPP()->settings_handler->get_option( 'active_fields' );
		if ( ! $active_fields ) {
			return $columns;
		}
		$columns['cb'] = '<input type="checkbox"/>';
		$columns['id'] = 'id';

		foreach ( $active_fields as $f => $v ) {
			$columns[ $f ] = $f;
		}
		$columns['qty'] = 'qty';
		return $columns;
	}

	public function column_cb( $item ) {
		?>
<input id="cb-select-<?php echo $item['id']; ?>"  type="checkbox" name="products[]" value="<?php echo $item['id']; ?>" />
		<?php
	}

	public function prepare_items() {

		$columns  = $this->get_columns();
		$hidden   = array( 'id' );
		$sortable = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );
		$category              = isset( $_REQUEST['product_cat_parent'] ) ? $_REQUEST['product_cat_parent'] : '';
		$product_name          = isset( $_REQUEST['product_name'] ) ? $_REQUEST['product_name'] : '';

		$args = array(
			's'              => $product_name,
			'post_type'      => 'product',
			'posts_per_page' => -1,
			'orderby'        => isset( $_REQUEST['orderby'] ) ? $_REQUEST['orderby'] : '',
			'order'          => isset( $_REQUEST['order'] ) ? $_REQUEST['order'] : '',
		);

		if ( $category > 0 ) {
			$tax_query = array(
				'tax_query' =>
									array(
										array(
											'taxonomy' => 'product_cat',
											'terms'    => $category,
											'operator' => 'IN',
										),
									),
			);
			$args      = array_merge( $args, $tax_query );
		}
		$loop = new WP_Query( $args );

		$ids        = array_map(
			function ( $post ) {
				return $post->ID;
			},
			$loop->posts
		);
		$a_products = self::get_products( $ids );

		$this->items = $a_products;
	}

	public static function get_products( $ids ) {
		$a_products = array();

		$i = 0;
		foreach ( $ids as $id ) {
			$active_fields = WCPP()->settings_handler->get_option( 'active_fields' );
			$product       = wc_get_product( $id );

			if ( self::get_product_type( $product ) === 'variable' ) {
				$variations = $product->get_available_variations();
				foreach ( $variations as $variation ) {
					$variation_data       = array();
					$variation_id         = $variation['variation_id'];
					$variation_data['id'] = $variation_id;

					foreach ( (array) $active_fields as $field => $v ) {
						if ( $field === 'sku' ) {
							$variation_data['sku'] = $variation['sku'];
						}

						if ( $field === 'name' ) {
							$variation_data['name'] = $product->get_title();
						}

						if ( $field === 'price' ) {
							$variation_data['price'] = wc_price( $variation['display_price'] );
						}

						if ( WCPP_Export_Tab::is_custom_field( $field ) ) {
							$variation_data[ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', wc_get_product( $variation_id ), $field );
						}

						if ( isset( $variation['attributes'][ "attribute_pa_$field" ] ) ) {
							if ( empty( $variation['attributes'][ "attribute_pa_$field" ] ) ) {
								$f                        = array_map(
									function ( $t ) {
										return $t->name;
									},
									get_terms( array( 'taxonomy' => "pa_$field" ) )
								);
								$variation_data[ $field ] = implode( ', ', $f );
							} else {
								$variation_data[ $field ] = $variation['attributes'][ "attribute_pa_$field" ];
							}
						}
					}

					$qty                   = get_post_meta( $variation_id, 'qty', true );
					$variation_data['qty'] = empty( $qty ) ? 100 : $qty;

					$variation_data['cb'] = 0;

					foreach ( (array) $active_fields as $field => $v ) {
						if ( ! isset( $variation_data[ $field ] ) ) {
							if ( $variationActiveFieldsTerms = wc_get_product_terms( $variation_id, "pa_$field" ) ) {
								$tmpTerms = array();
								foreach ( $variationActiveFieldsTerms as $term ) {
									if ( $term instanceof WP_Term ) {
										$termName = $term->name;
									} elseif ( is_string( $term ) ) {
										$termName = $term;
									} else {
										$termName = '';
									}

									$tmpTerms[] = $termName;
								}

								$variation_data[ $field ] = implode( ', ', $tmpTerms );
							}
						}
					}

					$a_products[ $i ] = $variation_data;
					++$i;
				}
			} else {
				$a_products[ $i ]['id'] = self::get_product_id( $product );
				$attr                   = $product->get_attributes();
				if ( $active_fields ) {
					foreach ( (array) $active_fields as $field => $v ) {
						if ( $field == 'sku' ) {
							$a_products[ $i ]['sku'] = $product->get_sku();
						}

						if ( $field == 'name' ) {
							$a_products[ $i ]['name'] = $product->get_title();
						}

						if ( $field == 'price' ) {
							$a_products[ $i ]['price'] = wc_price( $product->get_price() );
						}

						if ( WCPP_Export_Tab::is_custom_field( $field ) ) {
							$a_products[ $i ][ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', $product, $field );
						}

						if ( isset( $attr[ "pa_$field" ] ) ) {
							$t     = get_terms( array( 'taxonomy' => "pa_$field" ) );
							$terms = '';
							if ( $t ) {
								$terms = array_map(
									function ( $term ) {
										return $term->name;
									},
									$t
								);
								$terms = implode( ', ', $terms );
							}
							$a_products[ $i ][ $field ] = $terms;
						}
					}
				}

				$qty                     = get_post_meta( self::get_product_id( $product ), 'qty', true );
				$a_products[ $i ]['qty'] = empty( $qty ) ? 100 : $qty;
				$a_products[ $i ]['cb']  = 0;
			}

			++$i;
		}

		return $a_products;
	}

	function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			default:
				return isset( $item[ $column_name ] ) ? $item[ $column_name ] : '';
		}
	}

	public function get_sortable_columns() {
		$columns = array(
			'id'   => array( 'ID', false ),
			'name' => array( 'post_title', false ),
		);
		return $columns;
	}

	private static function get_product_id( $product ) {
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			return $product->id;
		} else {
			return $product->get_id();
		}
	}

	private static function get_product_type( $product ) {
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			return $product->product_type;
		} else {
			return $product->get_type();
		}
	}
}
