<?php

/**
 * WCPP_Pickingpal_Tab
 *
 * WooCommerce Picking Pal Picking Pal Tab
 *
 * @class       WCPP_Pickingpal_Tab
 * @category    Class
 */
class WCPP_Pickingpal_Tab extends WCPP_Tab {

	/**
	 * @var string Path to class views
	 */
	public $tab_name = 'pickingpal';

	/**
	 * @var WC_Order_Validate
	 */
	protected $order_validator;

	public function __construct() {
		parent::__construct();

		if ( class_exists( 'WC_Order_Validate_Impl_Pro' ) ) {
			$this->order_validator = new WC_Order_Validate_Impl_Pro();
		} else {
			$this->order_validator = new WC_Order_Validate_Impl();
		}
	}

	public function thematic_enqueue_scripts() {
		parent::thematic_enqueue_scripts();

		wp_enqueue_script( 'jquery-ui-progressbar' );
		wp_enqueue_script(
			'picker-woocommerce-pickingpal',
			WCPP()->plugin_js_url() . '/picker.js',
			array( 'jquery' ),
			WCPP_VERSION
		);

		$text = array(
			'product found'              => __( 'product found', 'woocommerce-pickingpal' ),
			'product not found'          => __( 'product not found', 'woocommerce-pickingpal' ),
			'bundle children started'    => __( 'Product bundle scan error', 'woocommerce-pickingpal' ),
			'Scan Order'                 => __( 'Scan Order', 'woocommerce-pickingpal' ),
			'Order Loaded'               => __( 'Order Loaded', 'woocommerce-pickingpal' ),
			'Order Not Found'            => __( 'Order Not Found', 'woocommerce-pickingpal' ),
			'Order Loaded (PICKED)'      => __( 'Order Loaded (PICKED)', 'woocommerce-pickingpal' ),
			'order_status_changed'       => __( 'Order status changed', 'woocommerce-pickingpal' ),
			'order_status_change_failed' => __( 'Order status change failed', 'woocommerce-pickingpal' ),
			'loading'                    => __( 'Loading...', 'woocommerce-pickingpal' ),
			'pick'                       => __( 'Pick', 'woocommerce-pickingpal' ),
		);
		wp_localize_script( 'picker-woocommerce-pickingpal', 'text', $text );
	}

	public function reset_order() {
		$order_number    = isset( $_REQUEST['order_number'] ) ? $_REQUEST['order_number'] : null;
		$order_id        = isset( $_REQUEST['order_id'] ) ? $_REQUEST['order_id'] : null;
		$trigger_barcode = isset( $_REQUEST['trigger_barcode'] ) ? (string) $_REQUEST['trigger_barcode'] : null;

		if ( $order_number && ! $order_id ) {
			$order_id = @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $order_number );
		}

		if ( ! $order_id ) {
			wp_die( __( 'Mist provide a valid `order_id`', 'woocommerce-pickingpal' ) );
		}
		$order = new WC_Order( $order_id );
		if ( ! $order->get_id() ) {
			wp_die( __( 'Mist provide a valid `order_id`', 'woocommerce-pickingpal' ) );
		}

		if ( WCPP()->is_hpos_enabled() ) {
			$order->delete_meta_data( WCPP()->get_meta_key( 'picker_data' ) );
		} else {
			delete_post_meta( $order_id, WCPP()->get_meta_key( 'picker_data' ) );
		}

		$actions_log_store = new WCPP_Order_Actions_Log_Store();
		$actions_log_store->set_order_id( $order_id );
		$actions_log_store->set_user( wp_get_current_user() );
		$actions_log_store->set_action_date_gmt( current_time( 'mysql' ) );
		$actions_log_store->set_action( $actions_log_store::ACTION_RESET_ORDER );
		$actions_log_store->save();

		$order_extend = new WCPP_Order_Extend( $order );
		$order_extend->set_order_number( $order->get_order_number() );
		$order_extend->save();

		echo json_encode( "delete post meta ($order_id)" );
		wp_die();
	}

	public function pick() {
		$order_number = isset( $_REQUEST['order_number'] ) ? $_REQUEST['order_number'] : null;
		$order_id     = isset( $_REQUEST['order_id'] ) ? $_REQUEST['order_id'] : null;

		if ( $order_number && ! $order_id ) {
			$order_id = @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $order_number );
		}

		$order = new WC_Order( $order_id );
		if ( ! $order->get_id() ) {
			wp_die( __( 'Mist provide a valid `order_id`', 'woocommerce-pickingpal' ) );
		}

		$picked_skus      = isset( $_REQUEST['picked_skus'] ) ? $_REQUEST['picked_skus'] : null;
		$percent_complete = isset( $_REQUEST['percent'] ) ? (int) $_REQUEST['percent'] : null;
		$picked_item      = isset( $_REQUEST['picked_item'] ) ? $_REQUEST['picked_item'] : null;
		$pick_arr         = isset( $_REQUEST['picked_items'] ) ? $_REQUEST['picked_items'] : null;

		// Log picked items array
		$picker_data = new WCPP_Picker_Data( $order_id );
		$r           = $picker_data->get_pick_arr( $order_id );
		if ( $r ) {
			$pick_arr = array_replace_recursive( $r, $pick_arr );
		}

		if ( WCPP()->is_hpos_enabled() ) {
			$order->update_meta_data( WCPP()->get_meta_key( 'picker_data' ), $pick_arr );
		} else {
			update_post_meta( $order_id, WCPP()->get_meta_key( 'picker_data' ), $pick_arr );
		}

		// Fire picked item events
		if ( $picked_item ) {
			$qty_required    = isset( $picked_item['qty_required'] ) ? $picked_item['qty_required'] : 1;
			$qty_picked      = isset( $picked_item['qty_picked'] ) ? $picked_item['qty_picked'] : 1;
			$qty_backordered = isset( $picked_item['backordered'] ) ? $picked_item['backordered'] : 0;
			$qty_available   = $qty_required - $qty_picked;
			if ( $qty_backordered && ( $qty_picked > $qty_available ) ) {
				do_action( 'pick_complete_back_ordered', $order_id, $picked_item );
			} else {
				do_action( 'pick_complete_in_stock', $order_id, $picked_item );
			}
		}

		// Log pick action
		$actions_log_store = new WCPP_Order_Actions_Log_Store();
		$actions_log_store->set_order_id( $order_id );
		$actions_log_store->set_user( wp_get_current_user() );
		$actions_log_store->set_action_date_gmt( current_time( 'mysql' ) );
		$actions_log_store->set_action( $actions_log_store::ACTION_PICK_ITEM );
		if ( $picked_item ) {
			$qty_adjustment      = isset( $picked_item['qty_adjustment'] ) ? $picked_item['qty_adjustment'] : 1;
			$new_picked_quantity = isset( $picked_item['qty_picked'] ) ? $picked_item['qty_picked'] : 1;
			$actions_log_store->set_order_item_id( $picked_item['order_item_id'] );
			$actions_log_store->set_quantity_adjustment( $qty_adjustment );
			$actions_log_store->set_total_picked_quantity( $new_picked_quantity );
		}
		$actions_log_store->save();

		// Log pick complete
		if ( $percent_complete === 100 ) {
			$actions_log_store = new WCPP_Order_Actions_Log_Store();
			$actions_log_store->set_order_id( $order_id );
			$actions_log_store->set_user( wp_get_current_user() );
			$actions_log_store->set_action_date_gmt( current_time( 'mysql' ) );
			$actions_log_store->set_action( $actions_log_store::ACTION_PICK_ORDER );
			$actions_log_store->save();
		}

		// Update order extend
		$order_extend = new WCPP_Order_Extend( $order );
		$order_extend->set_order_number( $order->get_order_number() );
		$order_extend->save();

		wp_die();
	}

	public function load_order() {
		if ( empty( $_REQUEST['order_number'] ) ) {
			wp_die();
		}

		$request_order_number = $_REQUEST['order_number'];
		$order_id             = @apply_filters(
			'woocommerce_shortcode_order_tracking_order_id',
			$request_order_number
		);
		$order                = WC_Order_Compat::get_order_compat( $order_id );

		if ( ! $order ) {
			wp_send_json_success( array( 'order_items' => null ) );
		}

		if ( ! $this->order_validator->is_valid_loaded_order( $order ) ) {
			wp_send_json_error( array( 'message' => $this->order_validator->get_last_error() ) );
		}

		//
		// Load Picker Data
		//
		$picker_data = new WCPP_Picker_Data( $order_id );
		$order_items = $picker_data->get_data();
		$pick_arr    = $picker_data->get_pick_arr( $order_id );

		//
		// Filter Picker Data!!
		//
		$v_control           = WCPP_Visibility_Controller::init();
		$show_product_images = $v_control->is_visible(
			$v_control::PRODUCT_IMAGE_FEATURE,
			$v_control::PICK_WINDOW_VIEW
		);
		foreach ( $order_items['products'] as &$product ) {
			$new_warehouse_labels = array();
			if ( isset( $product['warehouses'] ) ) {
				foreach ( $product['warehouses'] as $wh_key => $wh_data ) {
					if ( $v_control->is_visible( $wh_key, $v_control::PICK_WINDOW_VIEW ) ) {
						$new_warehouse_labels[] = $wh_data['label'] . ': ' . $wh_data['value'];
					}
				}
			}
			$product['warehouse'] = implode( ' | ', $new_warehouse_labels );

			$new_additional_sku_labels = array();
			foreach ( $product['additional_skus'] as $as_key => $as_data ) {
				if ( $v_control->is_visible( $as_key, $v_control::PICK_WINDOW_VIEW ) ) {
					$new_additional_sku_labels[] = $as_data['label'] . ': ' . $as_data['value'];
				}
			}
			$product['additional_sku_labels'] = implode( ' | ', $new_additional_sku_labels );

			// filter images
			if ( ! $show_product_images ) {
				unset( $product['image'] );
				unset( $product['image_url'] );
			}
		}

		if ( ! empty( $order_items ) ) {
			list( $order_items, $pick_arr ) = apply_filters(
				'wcpp_process_order_items',
				array(
					$order_items,
					$pick_arr,
				)
			);
		}

		//
		// Migration Consideration v1.3 Compat
		//
		if ( ( $pick_arr === false ) && $request_order_number != $order_id ) {
			// fix; migrate from v1.3.0: load by modified order number
			$pick_arr = $picker_data->get_pick_arr( $request_order_number );
			if ( ! empty( $pick_arr ) ) {
				if ( WCPP()->is_hpos_enabled() ) {
					$order->delete_meta_data( WCPP()->get_meta_key( 'picker_data' ) );
					$order->update_meta_data( WCPP()->get_meta_key( 'picker_data' ), $pick_arr );
				} else {
					delete_post_meta( $request_order_number, WCPP()->get_meta_key( 'picker_data' ) );
					update_post_meta( $order_id, WCPP()->get_meta_key( 'picker_data' ), $pick_arr );
				}
			}
		}

		//
		// Remove empty picked entries
		//
		if ( ! empty( $pick_arr ) ) {
			foreach ( $pick_arr as $index => $arr ) {
				if ( empty( $arr['qty_picked'] ) || $arr['qty_picked'] == '0' ) {
					unset( $pick_arr[ $index ] );
				}
			}
		}

		//
		// Log LOAD ORDER
		//
		$actions_log_store = new WCPP_Order_Actions_Log_Store();
		$actions_log_store->set_order_id( $order_id );
		$actions_log_store->set_user( wp_get_current_user() );
		$actions_log_store->set_action_date_gmt( current_time( 'mysql' ) );
		$actions_log_store->set_action( $actions_log_store::ACTION_LOAD_ORDER );
		$actions_log_store->save();

		//
		// Save Order Number Record
		//
		$order_extend = new WCPP_Order_Extend( $order );
		$order_extend->set_order_number( $order->get_order_number() );
		$order_extend->save();

		$data = array(
			'pick_arr'    => $pick_arr,
			'order_items' => $order_items,
		);
		wp_send_json_success( $data );
	}

	/**
	 * Log order as picked and fire event wcpp_pick_complete_full_order
	 *
	 * @return void ECHO JSON success message with new status
	 */
	public function set_picking_complete() {
		$order_number = isset( $_REQUEST['order_number'] ) ? $_REQUEST['order_number'] : null;
		$order_id     = isset( $_REQUEST['order_id'] ) ? $_REQUEST['order_id'] : null;

		if ( $order_number && ! $order_id ) {
			$order_id = @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $order_number );
		}

		if ( ! $order_id ) {
			wp_die( __( 'Mist provide a valid `order_id`', 'woocommerce-pickingpal' ) );
		}

		$order_id = intval( $order_id );
		$order    = wc_get_order( $order_id );

		$send_data = array();

		if ( $order ) {
			$order->add_order_note( 'PickingPal Verified' );
			$order->save();
			$send_data = apply_filters( 'wcpp_pick_complete_full_order', array(), $order_id );
		}

		if ( count( $send_data ) ) {
			wp_send_json_success( $send_data );
		} else {
			wp_die();
		}
	}


	/**
	 * Change order status with barcode scan
	 *
	 * @return void ECHO JSON success message with new status
	 */
	public function barcode_change_status() {
		$order_number    = isset( $_REQUEST['order_number'] ) ? $_REQUEST['order_number'] : null;
		$order_id        = isset( $_REQUEST['order_id'] ) ? $_REQUEST['order_id'] : null;
		$trigger_barcode = isset( $_REQUEST['trigger_barcode'] ) ? (string) $_REQUEST['trigger_barcode'] : null;

		if ( $order_number && ! $order_id ) {
			$order_id = @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $order_number );
		}

		if ( ! $trigger_barcode && ! $order_id ) {
			wp_send_json_error( __( 'Incorrect argument "trigger_barcode"', 'woocommerce-pickingpal' ) );
		}

		$new_status                      = null;
		$picking_enabled                 = null;
		$status_switch_via_barcode_units = WCPP()->settings_handler->get_option( 'status_switch_via_barcode_units' ) ?: array();

		foreach ( $status_switch_via_barcode_units as $unit ) {
			if ( ! isset( $unit['status'], $unit['barcode'] ) ) {
				continue;
			}

			if ( $unit['barcode'] === $trigger_barcode ) {
				wc_get_order( $order_id )->update_status(
					$unit['status'],
					__( 'PickingPal using barcode', 'woocommerce-pickingpal' ) . ': ' . $unit['barcode']
				);
				$new_status           = wc_get_order_status_name( $unit['status'] );
				$valid_order_statuses = WCPP()->settings_handler->get_option( 'valid_order_statuses' );
				if ( $valid_order_statuses && is_array( $valid_order_statuses ) ) {
					$picking_enabled = '0';
					if ( in_array( $unit['status'], $valid_order_statuses ) ) {
						$picking_enabled = '1';
					}
				}
				break;
			}
		}

		wp_send_json_success(
			array(
				'new_status'      => $new_status,
				'picking_enabled' => $picking_enabled,
			)
		);
	}
}
