<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WC_Order_Compat extends WC_Order {

	public static function get_order_compat( $order_id ) {
		if ( version_compare( WC()->version, '3.0.0', '<' ) ) {
			return new self( $order_id );
		}
		return wc_get_order( $order_id );
	}

	public function get_id() {
		return $this->id;
	}

	public function get_type( $context = 'view' ) {
		return $this->product_type;
	}

	public function get_date_created( $context = 'view' ) {
		return $this->order_date;
	}

	public function get_date_modified( $context = 'view' ) {
		return $this->post_date;
	}

	public function get_prices_include_tax( $context = 'view' ) {
		return $this->prices_include_tax;
	}
}
