<?php

function wc_pp_update_210_db_version() {
	global $wpdb;

	$old_postmeta_key             = '_wc_pickpal_log';
	$old_postmeta_last_log_id_key = '_wc_last_log_id';
	$new_postmeta_order_number    = '_pp_order_number';
	$log_table_name               = $wpdb->prefix . 'pp_pick_order_status';

	$query = $wpdb->prepare(
		"SELECT orders.ID, fields.meta_value
					FROM {$wpdb->postmeta} AS fields
						JOIN {$wpdb->posts} AS orders ON orders.ID = fields.post_id
					WHERE
						fields.meta_key = %s AND fields.meta_value IS NOT NULL",
		$old_postmeta_key
	);
	$rows  = $wpdb->get_results( $query );

	foreach ( $rows as $row ) {
		$order_id = $row->ID;
		$data     = unserialize( $row->meta_value );
		if ( ! $data ) {
			continue;
		}

		$user_id = isset( $data['scanned_by'] ) ? $data['scanned_by'] : null;
		if ( ! $user_id ) {
			continue;
		}

		$order_number = isset( $data['tracking_order_id'] ) ? $data['tracking_order_id'] : $order_id;

		$date_scanned = isset( $data['date_scanned'] ) ? $data['date_scanned'] : '';
		if ( ! $date_scanned ) {
			continue;
		}

		$date_last_pick = isset( $data['date_last_pick'] ) ? $data['date_last_pick'] : '';
		$processing     = isset( $data['processing'] ) ? $data['processing'] : '1';

		$query         = $wpdb->prepare( "INSERT INTO $log_table_name (`order_id`, `last_picked_by`, `date_scanned`,`date_last_picked`, `processing`) VALUES (%d, %d, %s, %s, %d)", $order_id, $user_id, $date_scanned, $date_last_pick, $processing );
		$insert_result = (bool) $wpdb->query( $query );

		$order_number_result = update_post_meta( $order_id, $new_postmeta_order_number, $order_number, true );

		// if ( $insert_result && $order_number_result ) {
		// delete_post_meta( $order_id, $old_postmeta_key );
		// delete_post_meta( $order_id, $old_postmeta_last_log_id_key );
		// }

	}
}

function wc_pp_update_220_migrate_visibility_options() {
	$v_control                         = WCPP_Visibility_Controller::init();
	$show_warehouse_location           = WCPP()->settings_handler->get_option( 'show_warehouse_location' ) === 'on';
	$show_product_image_on_pick_ticket = WCPP()->settings_handler->get_option( 'show_product_image_on_pick_ticket' ) === 'on';

	foreach ( WCPP()->settings_handler->get_skus( 'all' ) as $key => $sku_data ) {
		$v_control->set_status(
			$key,
			$v_control::PRODUCT_PAGE_VIEW,
			isset( $sku_data['product_page'] ) && $sku_data['product_page'] === 'on' ? $v_control::VISIBLE_STATUS : $v_control::HIDE_STATUS
		);
	}

	foreach ( WCPP()->settings_handler->get_warehouse_locations( 'all' ) as $key => $location ) {
		$v_control->set_status(
			$key,
			$v_control::PICK_TICKET_VIEW,
			isset( $location['pick_ticket'] ) && $location['pick_ticket'] === 'on' ? $v_control::VISIBLE_STATUS : $v_control::HIDE_STATUS
		);
		$v_control->set_status(
			$key,
			$v_control::PICK_LIST_VIEW,
			isset( $location['pick_list'] ) && $location['pick_list'] === 'on' ? $v_control::VISIBLE_STATUS : $v_control::HIDE_STATUS
		);

		if ( $show_warehouse_location ) {
			$v_control->set_status( $key, $v_control::PICK_TICKET_VIEW, isset( $location['pick_ticket'] ) && $location['pick_ticket'] === 'on' );
		}
	}

	if ( $show_warehouse_location ) {
		$v_control->set_status( $v_control::PRODUCT_IMAGE_FEATURE, $v_control::PICK_LIST_VIEW, $v_control::VISIBLE_STATUS );
		$v_control->set_status(
			$v_control::PRODUCT_IMAGE_FEATURE,
			$v_control::PICK_TICKET_VIEW,
			$show_product_image_on_pick_ticket ? $v_control::VISIBLE_STATUS : $v_control::HIDE_STATUS
		);
		$v_control->set_status( $v_control::PRODUCT_IMAGE_FEATURE, $v_control::PICK_WINDOW_VIEW, $v_control::VISIBLE_STATUS );
	}

	WCPP()->settings_handler->save_option( 'visibility', $v_control->get_statuses() );
}


function wc_pp_update_220_migrate_log_table() {
	global $wpdb;
	$log_table_name = $wpdb->prefix . 'pp_pick_order_status';
	$query          = $wpdb->prepare( "SELECT DISTINCT order_id,last_picked_by,date_scanned,date_last_picked,processing FROM {$log_table_name} ORDER BY date_last_picked" );
	$results        = $wpdb->get_results( $query, ARRAY_A );
	if ( ! $results ) {
		return;
	}

	foreach ( $results as $result ) {
		$log_store = new WCPP_Order_Actions_Log_Store();
		$log_store->set_order_id( (int) ( $result['order_id'] ) );
		$log_store->set_user_id( (int) ( $result['last_picked_by'] ) );
		$log_store->set_action( $log_store::ACTION_LOAD_ORDER );
		$log_store->set_action_date_gmt( $result['date_scanned'] );
		$log_store->save();

		if ( $result['date_last_picked'] ) {
			$log_store = new WCPP_Order_Actions_Log_Store();
			$log_store->set_order_id( (int) ( $result['order_id'] ) );
			$log_store->set_user_id( (int) ( $result['last_picked_by'] ) );
			$log_store->set_action( $log_store::ACTION_PICK_ITEM );
			$log_store->set_action_date_gmt( $result['date_last_picked'] );
			$log_store->save();

			if ( $result['processing'] === '0' ) {
				$log_store = new WCPP_Order_Actions_Log_Store();
				$log_store->set_order_id( (int) ( $result['order_id'] ) );
				$log_store->set_user_id( (int) ( $result['last_picked_by'] ) );
				$log_store->set_action( $log_store::ACTION_PICK_ORDER );
				$log_store->set_action_date_gmt( $result['date_last_picked'] );
				$log_store->save();
			}
		}
	}
}

function wc_pp_update_220_migrate_switch_order_status() {
	$transitions   = array();
	$transitions[] = array(
		'from' => WCPP()->settings_handler->get_option( 'switch_order_status_from' ),
		'to'   => WCPP()->settings_handler->get_option( 'switch_order_status_to' ),
	);

	WCPP()->settings_handler->save_option( 'pick_order_status_transitions', $transitions );
}
