<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_thickbox();
$sound_url            = WCPP()->plugin_sounds_url();
$loading_image_url    = WCPP()->plugin_imgs_url() . '/loading.gif';
$is_activated_license = WCPP()->is_activated();
$order_edit_uri       = add_query_arg(
	array(
		'post'   => '{{order_id}}',
		'action' => 'edit',
	),
	admin_url( 'post.php' )
);
if ( WCPP()->is_hpos_enabled() ) {
	$order_edit_uri = add_query_arg(
		array(
			'id'     => '{{order_id}}',
			'page'   => 'wc-orders',
			'action' => 'edit',
		),
		admin_url( 'admin.php' )
	);
}
?>
<div class="tabs-content__wrap" style="padding-right:20px;">
	<audio id="audio_order_load" src="<?php echo $sound_url; ?>/01-load-order-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_item_success" src="<?php echo $sound_url; ?>/02-pick-item-success-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_item_error" src="<?php echo $sound_url; ?>/03-pick-item-error-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_order_complete" src="<?php echo $sound_url; ?>/04-pick-order-complete-sound.mp3" preload="auto"  ></audio>
	<audio id="change_order_status" src="<?php echo $sound_url; ?>/05-change-order-status-sound.mp3" preload="auto"  ></audio>

	<div class="p_input__wrap">
		<div class="p_input">
			<label class="label_input_pp" for="pickingpal-input--order-number"><?php echo __( 'Order Number', 'woocommerce-pickingpal' ); ?></label>
			<input type="text" id="pickingpal-input--order-number" value="" <?php echo $is_activated_license ? '' : 'disabled'; ?>>
			<input type="button" class="button button-primary" id="pickingpal-btn--load-order" value="<?php _e( 'Load', 'woocommerce-pickingpal' ); ?>">
		</div>
		<div class="p_input">
			<label class="label_input_pp" for="pickingpal-input--product-sku"><?php echo __( 'Product SKU', 'woocommerce-pickingpal' ); ?></label>
			<input type="text" id="pickingpal-input--product-sku" value="">
			<input type="button" class="button button-primary" id="pickingpal-btn--pick" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ); ?>">
		</div>
	</div>

	<div id="pickingpal-progressbar">
		<div class="progress-label"></div>
	</div>

	<div id="pickingpal-status-x__wrap">
		<span id="pickingpal-status-x"></span>
		<span id="pickingpal-status-x-delimiter" style="display: none">|</span>
		<span id="pickingpal-order-status"></span>
	</div>

	<div class="pickingpal-items-row">
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Unpicked items', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--unpicked" class="pickingpal-itemslist__items"></div>
		</div>
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Picked items', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--picked" class="pickingpal-itemslist__items"></div>
		</div>
	</div>
	<div class="clearfix"></div>

	<div class="pickingpal-items-row">
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Unpicked items (backordered)', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--back-unpicked" class="pickingpal-itemslist__items"></div>
		</div>
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Picked items (backordered)', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--back-picked" class="pickingpal-itemslist__items"></div>
		</div>
	</div>
	<div class="clearfix"></div>

	<?php do_action( 'wcpp_after_view_items' ); ?>


	<div class="p_order_controls__wrap">
		<div class="left">
			<div class="p_input picking_status">
				<div style="line-height:30px;">
					<button class="button loading-button warning" id="pickingpal-btn--reset-picking-status" style="display: none;"
							title="<?php _e( 'Reset Picking Status', 'woocommerce-pickingpal' ); ?>">
						<img style="margin-left: -15px; width: 22px; vertical-align: text-bottom" src="<?php echo $loading_image_url; ?>">
						<?php _e( 'Reset picked items', 'woocommerce-pickingpal' ); ?>
					</button>
				</div>
			</div>
		</div>

		<div class="right">
			<div id="pickingpal-order-buttons">
				<button data-url="<?php echo $order_edit_uri; ?>"
						class="button button-primary"
						id="pickingpal-btn--view-order">
					<?php _e( 'View order', 'woocommerce-pickingpal' ); ?>
				</button>

				<button  data-url="<?php echo wp_nonce_url( admin_url( '?method=pickingpal_print_packing_slip&ids[0]=order_id' ) ); ?>"
						class="button button-primary"
						id="pickingpal-btn--print-slip">
					<?php _e( 'Print Packing Slip', 'woocommerce-pickingpal' ); ?>
				</button>
			</div>
		</div>
	</div>
	<br class="clear">
</div>

<!--PP-OVRD-ITM-QTY-->
<div id="pickingpal-modal--override-item">
	<h1>Pick item quantity</h1>
	<table>
		<tr>
			<td>
				<label for="pickingpal-input--sku-over"><?php echo _e( 'Product SKU', 'woocommerce-pickingpal' ); ?>:&nbsp;</label>
			</td>
			<td >
				<input style="width: 170px;" type="text" id="pickingpal-input--sku-over" >
			</td>
			<td>
				<input type="button" class="button button-primary" id="pickingpal-btn--load-product-over" value="<?php _e( 'Load', 'woocommerce-pickingpal' ); ?>">
			</td>
			<td>
				<input type="number" min="1" max="" id="pickingpal-input--qty-over" size="3" placeholder="<?php echo _e( 'Qty', 'woocommerce-pickingpal' ); ?>" style="max-width:70px;">
			</td>
			<td>
				<input type="button" class="button button-primary" id="pickingpal-btn--pick-over" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ); ?>" >
			</td>
		</tr>
		<tr>
			<td colspan="5" style="border: 1px solid #ddd;padding: 4px;height: 28px">
				<span style="" id="product_title_over"></span>
				<span id="product_qty_label_over" style="float: right;"></span>
			</td>
		</tr>
	</table>
</div>
<a id="pickingpal-thickbox--override-item" class='thickbox' href='#TB_inline?width=0&height=0&inlineId=pickingpal-modal--override-item' style="display: none;"></a>
