<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$help_image_url = isset( $help_image_url ) ? $help_image_url : null;
$metakey_skus   = array();
if ( isset( $options_handler ) ) {
	$fetched_metakey_skus = $options_handler->get_option( 'metakey_skus' );
	if ( is_array( $fetched_metakey_skus ) ) {
		$metakey_skus = $fetched_metakey_skus;
	}
}
?>

<tr>
	<td>
		<?php _e( 'Additional SKU', 'woocommerce-pickingpal' ); ?>
		<img class="help_tip" data-tip="ddd" src="<?php echo $help_image_url; ?>"
			title="
			<?php
				echo _e(
					'Additional SKU (ISBN/UPC) for books,packages and etc.',
					'woocommerce-pickingpal'
				)
				?>
				" height="16" width="16">
	</td>
	<td>

		<input type="hidden" name="remove_sku_ids"/>
		<button class='button-primary' onclick="add_sku();
						return false;" style='float:right;margin-bottom: 5px;'>
						<?php
						_e(
							'Add Sku',
							'woocommerce-pickingpal'
						)
						?>
				</button>
		<div style="clear:both"></div>

		<table class='simple-table-pp' id='skus'>
			<thead>
			<th><?php _e( 'Enabled', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( 'Label', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( '', 'woocommerce-pickingpal' ); ?></th>
			</thead>
			<tbody>
			<?php
			foreach ( $metakey_skus as $key => $sku ) {
				?>
				<tr>
					<td><input type=hidden name='sku[<?php echo $key; ?>][enabled]' value="off"/><input
							type="checkbox" <?php checked( $sku['enabled'], 'on' ); ?>
							name='sku[<?php echo $key; ?>][enabled]' value="on"/></td>
					<td><input type='text' name='sku[<?php echo $key; ?>][label]'
								value='<?php echo $sku['label']; ?>'/></td>
					<td><a onclick='remove_sku(this, "<?php echo $key; ?>//");
							return false;'><span class="dashicons dashicons-trash"></span></a></td>
				</tr>
			<?php } ?>

			</tbody>
		</table>

	</td>
</tr>
