<?php
/**
 * @deprecated Use print_pick_ticket.php instead
 * // PRINT PICK TICKET
 *
 * @var WC_Order[] $orders
 * @var string $url_list_css
 */
?>

<link rel="stylesheet" type="text/css" href="<?php echo $url_list_css; ?>">
<div class="page">
	<?php
	// Pick Ticket

	$v_control = WCPP_Visibility_Controller::init();

	// $tax_display = get_option('pickingpal-show_taxes') ? 'incl' : '';
	$tax_display = WCPP()->settings_handler->get_option( 'show_taxes' ) ? 'incl' : '';

	$warehouse_locations = array_filter(
		WCPP()->settings_handler->get_warehouse_locations( 'only_enabled' ),
		function ( $data, $key ) use ( $v_control ) {
			return $v_control->is_visible( $key, $v_control::PICK_TICKET_VIEW );
		},
		ARRAY_FILTER_USE_BOTH
	);

	$additional_skus = array_filter(
		WCPP()->settings_handler->get_skus( 'only_enabled' ),
		function ( $data, $key ) use ( $v_control ) {
			return $v_control->is_visible( $key, $v_control::PICK_TICKET_VIEW );
		},
		ARRAY_FILTER_USE_BOTH
	);

	$img = get_option( 'pickingpal-logo' );
	$img = WCPP()->settings_handler->get_option( 'url_file' );

	$pg_num = 0;

	$show_product_images = $v_control->is_visible( $v_control::PRODUCT_IMAGE_FEATURE, $v_control::PICK_TICKET_VIEW );
	$show_customer_notes = $v_control->is_visible( $v_control::CUSTOMER_ORDER_NOTES_FEATURE, $v_control::PICK_TICKET_VIEW );

	if ( $show_product_images ) {
		$pick_ticket_columns['image'] = __( 'Image', 'woocommerce-pickingpal' );
	}
	$pick_ticket_columns['order_item'] = __( 'Order Item', 'woocommerce-pickingpal' );
	if ( count( $additional_skus ) ) {
		$pick_ticket_columns['additional_skus'] = __( 'Additional SKUs', 'woocommerce-pickingpal' );
	}
	if ( count( $warehouse_locations ) ) {
		$pick_ticket_columns['warehouse_location'] = __( 'Warehouse location', 'woocommerce-pickingpal' );
	}
	$pick_ticket_columns['price']    = __( 'Price', 'woocommerce-pickingpal' );
	$pick_ticket_columns['qty']      = __( 'Quantity', 'woocommerce-pickingpal' );
	$pick_ticket_columns['subtotal'] = __( 'Subtotal', 'woocommerce-pickingpal' );

	$pick_ticket_columns = apply_filters( 'wcpp_pick_ticket_columns', $pick_ticket_columns );

	foreach ( $orders as $order ) {

		if ( version_compare( WC_VERSION, '3.0', '<' ) ) {
			$display_cart_ex_tax = $order->display_cart_ex_tax;
		} else {
			$display_cart_ex_tax = 'excl' === get_option( 'woocommerce_tax_display_cart' );
		}

		++$pg_num;
		$order_number   = ltrim( $order->get_order_number(), '#' );
		$billing_phone  = $order->get_billing_phone();
		$shipping_phone = $order->get_shipping_phone();
		?>
		<div>
		<?php if ( $img ) : ?>
			<img src="<?php echo $img; ?>" class="logo">
		<?php endif; ?>
		</div>
		<div class="info">
<!--            --><?php // echo nl2br( get_option( 'pickingpal-contact' ) ); ?>
			<?php echo nl2br( WCPP()->settings_handler->get_option( 'contact' ) ); ?>
		</div>
		<div class="clearfix"></div>
		<div class="border-x"></div>

		<div class="header">
			<div class="header-left">
				<table>
					<tr>
						<td>
							<h3><?php echo __( 'Billing Address', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2">
								<?php echo $order->get_formatted_billing_address(); ?>
								<?php echo $billing_phone ? '<br/>Phone: ' . $billing_phone : null; ?>
							</div>
						</td>
						<td>
							<h3><?php echo __( 'Shipping Address', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2">
								<?php echo $order->get_formatted_shipping_address(); ?>
								<?php echo $shipping_phone ? '<br/>Phone: ' . $shipping_phone : null; ?>
							</div>
						</td>
						<td>
							<h3><?php echo __( 'Shipping method', 'woocommerce-pickingpal' ); ?></h3>
							<div class="info2"><?php echo $order->get_shipping_method(); ?></div>
						</td>
						<td>
							<h3><?php echo __( 'Total amount', 'woocommerce-pickingpal' ); ?></h3>
							<div><?php echo $order->get_formatted_order_total(); ?></div>
							<div>
							<?php
								$post_date = is_string( $order->get_date_modified() ) ? strtotime( $order->get_date_modified() ) : $order->get_date_modified()->getOffsetTimestamp();
							if ( ! empty( $post_date ) ) {
								echo date( 'm-d-Y', $post_date );
							}
							?>
							</div>
						</td>
					</tr>
				</table>

				<h3>
				<?php
					echo __( 'Order Date: ', 'woocommerce-pickingpal' );
					$order_date_timestamp = is_string( $order->get_date_created() ) ? strtotime( $order->get_date_created() ) : $order->get_date_created()->getOffsetTimestamp();
					echo date( 'm-d-Y', $order_date_timestamp );
				?>
					</h3>

				<?php if ( $show_customer_notes ) : ?>
					<h3>
						<?php
						$customer_notes = $order->get_customer_note() ? $order->get_customer_note() : '---';
						printf( '%s : %s', __( 'Customer notes', 'woocommerce-pickingpal' ), $customer_notes );
						?>
					</h3>
				<?php endif; ?>
			</div>
			<div class="header-right">
				<div class="barcode">
					<div><?php echo __( 'Invoice', 'woocommerce-pickingpal' ); ?> #<?php echo $order_number; ?></div>
					<font face="IDAutomationHC39M">(<?php echo $order_number; ?>)</font>
				</div>

<!--                <div class="picktiket-heading">--><?php // echo get_option( 'pickingpal-picktiket_heading' ); ?><!--</div>-->
				<div class="picktiket-heading"><?php echo WCPP()->settings_handler->get_option( 'picktiket_heading' ); ?></div>
			</div>
		</div>


		<table class="products-list">
			<tr class="item-line">
				<?php foreach ( $pick_ticket_columns as $column_index => $label ) : ?>
					<th class="header-list"><?php echo $label; ?></th>
				<?php endforeach; ?>
			</tr>
		<?php

		$rows     = array();
		$subtotal = 0;

		foreach ( $order->get_items() as $item ) {

			$_product = $item->get_product();
			if ( ! $_product ) {
				continue;
			}

			$sku = $variation = '';
			if ( $_product ) {
				$sku = $_product->get_sku();
			}

			$variation = implode(
				' | ',
				array_map(
					function ( $e ) {
						return $e['label'] . ': ' . $e['value'];
					},
					WCPP_Admin_Helper::get_product_variations( $_product )
				)
			);

			if ( $display_cart_ex_tax || ! $order->get_prices_include_tax() ) {
				$ex_tax_label = ( $order->get_prices_include_tax() ) ? 1 : 0;
				$price        = wc_price( $order->get_line_total( $item ), array( 'ex_tax_label' => $ex_tax_label ) );
				$item_price   = wc_price( $order->get_item_total( $item ), array( 'ex_tax_label' => $ex_tax_label ) );
				$subtotal    += $order->get_line_total( $item );
			} else {
				$price      = wc_price( $order->get_line_total( $item, true ) );
				$item_price = wc_price( $order->get_item_total( $item, true ) );
				$subtotal  += $order->get_line_total( $item, true );
			}

			$discount         = wc_price( $item->get_total() - $item->get_subtotal() );
			$product_discount = wc_price( ( $item->get_total() - $item->get_subtotal() ) / $item->get_quantity() );

			$item_warehouse_locations = array();
			foreach ( WCPP()->settings_handler->get_warehouse_locations( 'only_enabled' ) as $key => $location ) {
				if ( $v_control->is_visible( $key, $v_control::PICK_TICKET_VIEW ) ) {
					$product_location = get_post_meta( $_product->get_id(), $key );
					if ( ! empty( $product_location[0] ) ) {
						$item_warehouse_locations[] = $location['label'] . ' : ' . $product_location[0];
					}
				}
			}

			$item_additional_skus = array();
			foreach ( WCPP()->settings_handler->get_skus( 'only_enabled' ) as $key => $sku_data ) {
				if ( $v_control->is_visible( $key, $v_control::PICK_TICKET_VIEW ) ) {
					$product_sku = get_post_meta( $_product->get_id(), $key );
					if ( ! empty( $product_sku[0] ) ) {
						$item_additional_skus[] = $sku_data['label'] . ' : ' . $product_sku[0];
					}
				}
			}

			$rows[] = array(
				'name'               => apply_filters( 'woocommerce_order_product_title', $item['name'], $_product ),
				'variation'          => $variation,
				'sku'                => $sku,
				'warehouse_location' => implode( '<br>', $item_warehouse_locations ),
				'additional_skus'    => implode( '<br>', $item_additional_skus ),
				'product_price'      => $item_price,
				'product_discount'   => $product_discount,
				'qty'                => $item['qty'],
				'price'              => $price,
				'discount'           => $discount,
				'image'              => $_product->get_image( 'thumbnail' ),
			);
		}

		// if ( get_option('pickingpal-sort_by_warehouse_location') ) {
		if ( wc_string_to_bool( WCPP()->settings_handler->get_option( 'sort_by_warehouse_location' ) ) ) {
			$rows = WCPP()->helper->sort_array_empty_last( $rows, 'warehouse_location' );
		}

		foreach ( $order->get_fees() as $fee ) {

			$rows[] = array(
				'name'               => $fee->get_name(),
				'variation'          => '',
				'sku'                => '',
				'warehouse_location' => '',
				'product_price'      => '',
				'product_discount'   => '',
				'qty'                => '',
				'price'              => wc_price( $fee->get_total() ),
				'discount'           => '',
				'image'              => '',
			);

			$subtotal += $fee->get_total();
		}


		foreach ( $rows as $item ) :
			?>
			<?php $num_index = 0; ?>

		<tr class="item-line">
				<?php
				foreach ( $pick_ticket_columns as $column => $column_label ) :
					// render empty column for barcode
					?>
					<?php
					switch ( $column ) :
						case 'order_item':
							?>
					<td>
						<div><?php echo $item['name']; ?></div>
						<div><?php echo $item['variation']; ?></div>
								<?php if ( $item['sku'] ) : ?>
							<div><?php _e( 'SKU', 'woocommerce-pickingpal' ); ?>: <?php echo $item['sku']; ?></div>
						<?php endif; ?>
					</td>
							<?php break; ?>

							<?php
							case 'warehouse_location':
								if ( count( $warehouse_locations ) ) {
									echo '<td>' . $item['warehouse_location'] . '</td>';
								}
								?>
							<?php break; ?>
							<?php
							case 'additional_skus':
								if ( count( $additional_skus ) ) {
									echo '<td>' . $item['additional_skus'] . '</td>';
								}
								?>
							<?php break; ?>
							<?php
							case 'price':
								?>
					<td>
						<div><?php echo $item['product_price']; ?></div>
						<div><?php echo $item['product_discount']; ?></div>
					</td>
					<?php break; ?>
							<?php
							case 'qty':
								?>
					<td>
								<?php echo $item['qty']; ?>
					</td>
					<?php break; ?>

							<?php
							case 'subtotal':
								?>
					<td>
						<div><?php echo $item['price']; ?></div>
						<div><?php echo $item['discount']; ?></div>
					</td>
					<?php break; ?>
							<?php
							case 'image':
								?>
					<td>
								<?php echo $item['image']; ?>
					</td>
					<?php break; ?>
					<?php endswitch; ?>
						<?php
						do_action( 'wcpp_pick_ticket_render_column_row', $column, $item );
						++$num_index;
						?>

				<?php endforeach; ?>
		</tr>
		<?php endforeach; ?>

			<tr class="total-x">
				<?php
				if ( $show_product_images ) {
					echo '<td></td>';}
				?>
				<td></td>
				<?php
				if ( count( $additional_skus ) ) {
					echo '<td></td>';}
				?>
				<?php
				if ( count( $warehouse_locations ) ) {
					echo '<td></td>';}
				?>
				<td></td>
				<td class="item-line"><?php echo __( 'Subtotal', 'woocommerce-pickingpal' ); ?>:</td>
				<td class="item-line">
					<?php echo wc_price( $subtotal ); ?>
				</td>
			</tr>
			<tr class="total-x">
				<?php
				if ( $show_product_images ) {
					echo '<td></td>';}
				?>
				<td></td>
				<?php
				if ( count( $additional_skus ) ) {
					echo '<td></td>';}
				?>
				<?php
				if ( count( $warehouse_locations ) ) {
					echo '<td></td>';}
				?>
				<td></td>
				<td class="item-line"><?php echo __( 'Shipping', 'woocommerce-pickingpal' ); ?>:</td>
				<?php
					$shipping_price = wc_price( $order->get_shipping_total() + $order->get_shipping_tax(), array( 'currency' => $order->get_currency() ) );
				?>
				<td class="item-line"><?php echo $shipping_price . '' . apply_filters( 'woocommerce_order_shipping_to_display_shipped_via', '&nbsp;<small class="shipped_via">' . sprintf( __( 'via %s', 'woocommerce' ), $order->get_shipping_method() ) . '</small>', $order ); ?></td>
			</tr>
			<tr class="total-x">
				<?php
				if ( $show_product_images ) {
					echo '<td></td>';}
				?>
				<td></td>
				<?php
				if ( count( $additional_skus ) ) {
					echo '<td></td>';}
				?>
				<?php
				if ( count( $warehouse_locations ) ) {
					echo '<td></td>';}
				?>
				<td></td>
				<td class="item-line"><?php echo __( 'Discount', 'woocommerce-pickingpal' ); ?>:</td>
				<td class="item-line">
					<?php echo $order->get_discount_to_display(); ?>
				</td>
			</tr>
			<tr class="total">
				<?php
				if ( $show_product_images ) {
					echo '<td></td>';}
				?>
				<td></td>
				<?php
				if ( count( $additional_skus ) ) {
					echo '<td></td>';}
				?>
				<?php
				if ( count( $warehouse_locations ) ) {
					echo '<td></td>';}
				?>
				<td></td>
				<td>Total:</td>
				<td>
					<?php echo $order->get_formatted_order_total( $tax_display ); ?>
				</td>
			</tr>
		</table>
		<?php if ( $pg_num < count( $orders ) ) { ?>
		<p class="pagebreak"></p>
		<?php } ?>
		<?php
	}
	?>
</div>
<script>
	if(document.images.length){ //wait for images to load
		Promise.all(Array.from(document.images).filter(img => !img.complete).map(img => new Promise(resolve => { img.onload = img.onerror = resolve; }))).then(() => {
			window.print();
		});
	} else {
		window.print();
	}
</script>
