<?php
/**
 * @deprecated Use template_print_pick_list.php instead
 *
 * // PRINT PICK LIST
 *
 * @var array $items
 * @var string $url_list_css
 * @var int $total
 * @var int $total_orders
 * @var bool $with_warehouse_locations
 * @var bool $with_additional_skus
 */

?>
<link rel="stylesheet" type="text/css" href="<?php echo $url_list_css; ?>">
<div class="page">
	<div>
		<div class="pull-right"><?php echo current_time( 'l, F d Y h:i A' ); ?></div>
		<h1><strong><?php _e( 'Product Pick List', 'woocommerce-pickingpal' ); ?></strong></h1>
	</div>
	<div class="clearfix"></div>
	<table class="pick-list" cellspacing="0" cellpadding="10" width="100%">
		<thead>
		<tr>
			<th><?php _e( '&nbsp;', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( 'Item #', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( 'Description', 'woocommerce-pickingpal' ); ?></th>
			<?php if ( $with_additional_skus ) : ?>
				<th><?php _e( 'Additional SKUs', 'woocommerce-pickingpal' ); ?></th>
			<?php endif; ?>
			<?php if ( $with_warehouse_locations ) : ?>
			<th><?php _e( 'Warehouse Location', 'woocommerce-pickingpal' ); ?></th>
			<?php endif; ?>
			<th><?php _e( '# Required', 'woocommerce-pickingpal' ); ?></th>
			<th><?php _e( '# Restocked', 'woocommerce-pickingpal' ); ?></th>
		</tr>
		</thead>
		<tbody>
					<tr><td colspan="5" class="top-divider"><div class="hr"></div></td></tr>
		<?php foreach ( $items as $product_id => $item ) : ?>
			<tr>
				<td><?php echo isset( $item['image'] ) ? $item['image'] : ''; ?></td>
				<td>
					<?php
					echo $item['sku'];
					if ( ! empty( $item['meta_data'] ) ) {
						$var_array = array( '<br>' );
						foreach ( $item['meta_data'] as $var_label => $var_val ) {
							$var_array[] = "<span>{$var_label}: <strong>{$var_val}</strong></span>";
						}
						echo implode( '<br>', $var_array );
					}
					?>
				</td>
				<td><?php echo $item['name']; ?></td>
				<?php if ( $with_additional_skus ) : ?>
					<td><?php echo implode( '<br>', $item['additional_skus'] ); ?></td>
				<?php endif; ?>
				<?php if ( $with_warehouse_locations ) : ?>
				<td><?php echo $item['warehouse_location']; ?></td>
				<?php endif; ?>
				<td><?php echo $item['qty_required']; ?></td>
				<td><?php echo $item['qty_restocked']; ?></td>
			</tr>
			<?php do_action( 'wcpp_after_pick_list_row', $item, $total_orders ); ?>
			<tr><td colspan="6" class="divider"><div class="hr"></div></td></tr>
		<?php endforeach ?>
		</tbody>
	</table>
	<div>
		<div class="pull-right"><h3><?php printf( __( 'Total Items Required: %d', 'woocommerce-pickingpal' ), $total ); ?></h3></div>
	</div>
</div>
<script>
	if(document.images.length){ //wait for images to load
		Promise.all(Array.from(document.images).filter(img => !img.complete).map(img => new Promise(resolve => { img.onload = img.onerror = resolve; }))).then(() => {
			window.print();
		});
	} else {
		window.print();
	}
</script>
