<?php
/**
 * Plugin Name: WooCommerce PickingPal
 * Plugin URI: https://pickingpal.com
 * Description: Helps achieve 100% order picking & shipping accuracy. Never send out an incomplete order or the wrong items to your Customers ever again. Scan your order barcode, scan your items, and let PickingPal do the rest!
 * Author: PickingPal
 * Author URI: https://pickingpal.com/
 * Version: 2.6.2
 * Text Domain: woocommerce-pickingpal
 * Domain Path: /i18n/languages/
 * Requires at least: 5.0
 * Tested up to: 6.4.2
 * WC requires at least: 3.9
 * WC tested up to: 8.5.2
 *
 * Copyright: (c) 2014-2023 PickingPal (info@pickingpal.com)
 *
 * @package     woocommerce-pickingpal
 * @author      author
 * @Category    Plugin
 * @copyright   Copyright (c) 2014-2023, PickingPal
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'SECONDS_IN_HOUR' ) ) {
	define( 'SECONDS_IN_HOUR', 60 * 60 );
}

// Define WCPP_PLUGIN_FILE.
if ( ! defined( 'WCPP_PLUGIN_FILE' ) ) {
	define( 'WCPP_PLUGIN_FILE', __FILE__ );
}

if ( ! class_exists( 'WC_PickingPal' ) ) {
	include_once 'includes/class-wc-pickingpal.php';
}

/**
 * WC Detection
 *
 * @return boolean
 */
if ( ! function_exists( 'is_woocommerce_active' ) ) {
	function is_woocommerce_active() {
		$active_plugins = (array) get_option( 'active_plugins', array() );

		if ( is_multisite() ) {
			$active_plugins = array_merge( $active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );
		}

		return in_array( 'woocommerce/woocommerce.php', $active_plugins ) || array_key_exists( 'woocommerce/woocommerce.php', $active_plugins );
	}
}

$wc_pickingpal = WCPP();

/**
 * APP Constants
 */

if ( ! defined( 'WCPP_WEBSITE' ) ) {
	define( 'WCPP_WEBSITE', $wc_pickingpal->get_website() );
}

if ( ! defined( 'WCPP_VERSION' ) ) {
	define( 'WCPP_VERSION', $wc_pickingpal->get_version() );
}

if ( ! defined( 'WCPP_APP_NAME' ) ) {
	define( 'WCPP_APP_NAME', $wc_pickingpal->get_app_name() );
}
if ( ! defined( 'WCPP_IS_PRO' ) ) {
	define( 'WCPP_IS_PRO', $wc_pickingpal->is_pro() );
}
if ( ! defined( 'WCPP_PRODUCT_ID' ) ) {
	define( 'WCPP_PRODUCT_ID', $wc_pickingpal->get_app_product_id() );
}
if ( ! defined( 'WCPP_PRODUCT' ) ) {
	define( 'WCPP_PRODUCT', $wc_pickingpal->get_app_product_name() );
}

/**
 * Activate
 */
add_filter(
	'http_request_host_is_external',
	function () {
		return true;
	},
	1
);
if ( is_woocommerce_active() ) {
	$wc_pickingpal->init();
	register_activation_hook( __FILE__, array( 'WCPP_Install', 'install' ) );
} else {
	add_action(
		'admin_notices',
		function () {
			if ( current_user_can( 'activate_plugins' ) ) {
				$warning_msg    = __( '%1$sWooCommerce %7$s is inactive%2$s. %3$sWooCommerce plugin %4$s must be active for %7$s to work. Please %5$sinstall and activate WooCommerce &raquo;%6$s', 'woocommerce-pickingpal' );
				$warning_output = sprintf(
					$warning_msg,
					'<strong>',
					'</strong>',
					'<a href="http://wordpress.org/extend/plugins/woocommerce/">',
					'</a>',
					'<a href="' . esc_url( admin_url( 'plugins.php' ) ) . '">',
					'</a>',
					WCPP_APP_NAME
				);
				echo esc_html( '<div id="message" class="error"><p>' . $warning_output . '</p></div>' );
			}
		}
	);
}
