jQuery( document ).ready( function ( $ ) {
	var $input_api_key = $( '#api_key' );

	$input_api_key.on( 'input propertychange', function () {
		$( this ).siblings( '.is_valid' ).html( make_dashicon( is_api_key( this.value ) ) );
		submit_button_check();
	} ).trigger( 'input' );

	function make_dashicon( $value ) {
		if ( $value ) {
			return "<span class='dashicons dashicons-yes' style='color: #66ab03;'></span>";
		} else {
			return "<span class='dashicons dashicons-no' style='color: #ca336c;'></span>";
		}
	}

	function submit_button_check() {
		if ( is_api_key( $input_api_key.prop( 'value' ) ) ) {
			$( '#submit' ).prop( 'disabled', false );
		} else {
			$( '#submit' ).prop( 'disabled', true );
		}
	}

	function is_api_key( $api_key ) {
		return ! (
			typeof $api_key !== 'string' || $api_key.length !== 40
		);
	}


} );